#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"

#define ONESEC      0.25
#define DONEMESS    "DONE"
#define TIMESCALING 4.0
#define LCDLEN       10
#define FIXEDWPM    13


SLCD slcd; //define LCD display
// keyer test
TSISensor tsiScaling; // Capacitive sensor/slider
DigitalIn RtButton(PTC12);
DigitalIn LftButton(PTC3);

PwmOut soundOut(PTA13);
char lcdData[LCDLEN];



void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 




void secondsCountdown(int secCount){
    int i;
    float fracSec;
    int twoCount;
    twoCount = (int)TIMESCALING*secCount;
    for (i=twoCount; i>=0; i--){
        fracSec = (float)i/TIMESCALING;
        sprintf (lcdData,"%4.1f",fracSec);
        LCDMessNoDwell(lcdData);
        wait(ONESEC);
    }
    return;
}

int main(){
    
    int RButtonState;
    int LButtonState;
    float tempValue;
    int sCount = FIXEDWPM;
   
    sprintf (lcdData,"%d",sCount);
    LCDMessNoDwell(lcdData);
    
    
    while (true) {
  
        RButtonState = !RtButton.read();
        LButtonState = !LftButton.read();
        if(RButtonState) {
          secondsCountdown(sCount);
          LCDMessNoDwell(DONEMESS);
        } 
      
    } // while forever
}// end main