#include "mbed.h"
#include "rtos.h"
#include "SLCD.h"

#define RANDLIMIT 2000
#define RANDOFFSET 200
#define T1INTERVAL 750 // ms
#define T2INTERVAL 500 // ms
#define BUTTON_INT 100 //ms
#define NUMSTATES 2
#define GDISPLAY 0
#define RDISPLAY 1
#define LCDLEN 10
#define LEDON 0
#define LEDOFF 1

SLCD slcd; //define LCD display
 
DigitalOut gLed(LED_GREEN);
DigitalOut rLed(LED_RED);
int LButtonState;
DigitalIn LftButton(PTC3);
int displayState;
char LCDActual[LCDLEN];


void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 
void LCDdis_thread(void const *args){
    while(true) {
        LCDMess(LCDActual);
        Thread::wait(BUTTON_INT);
    }
}
void button_thread(void const *args) {
    int LButtonState;
    while (true) {
        LButtonState = !LftButton;
        if (LButtonState) {  //Change data that is displayed cycle through states 
            displayState++;
            displayState = displayState % NUMSTATES;  
        }
        Thread::wait(BUTTON_INT);
    }
}


void gLed_thread(void const *args) {
    int interval;
    while (true) {
        gLed = !gLed;
        interval = rand()% RANDLIMIT + RANDOFFSET;  
        if(displayState == GDISPLAY) {
            sprintf (LCDActual, "Y.%3d", interval/10);
        }         
        Thread::wait(interval);
    }
}
 
int main() {
    srand(time(NULL));
    int interval;
    Thread gthread(gLed_thread);
    Thread bthread(button_thread);
    Thread lthread(LCDdis_thread);
    
    rLed = LEDON;
    gLed = LEDOFF;
    
    while (true) { // Red LED thread
        rLed = !rLed;
        interval = rand()% RANDLIMIT + RANDOFFSET; 
        if(displayState == RDISPLAY) {
            sprintf (LCDActual, "R.%d",interval/10);
        }      
        Thread::wait(interval);
    }
}
