#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"

#define ONESEC      1.009f // tweak for accuracy
#define LEDTIME     0.2
#define TOUCHDELAY  0.100
#define DONEMESS    "DONE"
#define TIMESCALING     1.0
#define LCDLEN       10
#define MAXMIN      55
#define LEDON       false
#define LEDOFF      true
#define SECSPERMIN    60 // using modulus
// Define states
#define NOBLINK     0 // "done" condition
#define BLINK       1
#define PERIODSELECT    0
#define TIMING          1

SLCD slcd; //define LCD display
TSISensor tsiScaling; // Capacitive sensor/slider
DigitalIn RtButton(PTC3);
DigitalIn LftButton(PTC12);
DigitalOut greenColor(LED_GREEN);
DigitalOut redColor(LED_RED);

Timer LEDTimer;
Timer SecondsTimer;

char lcdData[LCDLEN]; //Global character buffer for LCD

void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void LEDFlipState(){
    static bool LEDState = LEDOFF;
    
    redColor.write(LEDState);
    greenColor.write(!LEDState);
    LEDState = !LEDState;
    return;
}

void LEDSOff(){
    redColor.write(LEDOFF);
    greenColor.write(LEDOFF);
    return;
}
    




int main(){
    
    int RButtonState;
    int LButtonState;
    float tempValue; // for touch value
    int mCount = MAXMIN;
    int secCount = SECSPERMIN;
    int totalSecs= 0;
    // define two state machine variables
    int IndicatorState = NOBLINK;
    int TimerState = PERIODSELECT;
   
// default display 
    sprintf (lcdData,"%d",mCount);
    LCDMessNoDwell(lcdData);
    LEDTimer.start();
    LEDTimer.reset();  
    SecondsTimer.start();
    SecondsTimer.reset(); 
    
    while (true) {
        
        RButtonState = !RtButton.read();
        LButtonState = !LftButton.read();
        if(LButtonState) {  // Stop the timer
            TimerState = PERIODSELECT;
            IndicatorState = BLINK;
        }
        
        switch (TimerState){
            case PERIODSELECT: {
                tempValue = tsiScaling.readPercentage();
                if(tempValue > 0) {  // Standard way of handling slider
                    IndicatorState = NOBLINK;
                    mCount = int((float)MAXMIN *tempValue); // get minutes
                    sprintf (lcdData,"%d",mCount);
                    LCDMessNoDwell(lcdData);
                    wait(TOUCHDELAY);
                }        
                if(RButtonState) { //start the timer
                    SecondsTimer.reset();
                    // secCount = SECSPERMIN + 1; // 1st time through
                    totalSecs = mCount * SECSPERMIN;
                    TimerState = TIMING;
                }
                break;
              }
              
              case TIMING: {
                if (SecondsTimer.read() >  ONESEC) {  
                    totalSecs--;
                    mCount = totalSecs / SECSPERMIN;  // Quotient
                    secCount = totalSecs % SECSPERMIN; // Remainder
                    if(totalSecs < 0){
                        IndicatorState = BLINK;
                        TimerState = PERIODSELECT;
                    }
                    sprintf (lcdData,"%2d%2d",mCount, secCount); // Display countdown
                    LCDMessNoDwell(lcdData);
                    slcd.Colon(true);
                    SecondsTimer.reset();
                }
                break;
              }      
            }// end TimerState switch
        
        
        
        
            
  //  Timer Completion indicator
            
        if(LEDTimer.read() > LEDTIME){ 
            LEDTimer.reset();
            switch (IndicatorState){
                case BLINK: {
                    LEDFlipState();
                    LCDMessNoDwell(DONEMESS);  
                    break;
                }
                case NOBLINK: {
                    LEDSOff();
                    break;
                }
            } //end case
        }// end LEDTimer if
    } // while forever
}// end main