#include "mbed.h"

#define LEDOFF 1
#define LEDON 0
#define DATATIME 0.4
// temp contants
#define REFVOLTS 1.29
#define REFTEMP 30.0
#define VDD 3.3
#define TEMPSLOPE -0.0081
// Conversion to F
#define CZERO 32.0
#define CFSLOPE 1.8


Serial pc(USBTX, USBRX);
DigitalOut myRled(LED_RED);
DigitalOut myGled(LED_GREEN);
DigitalOut myBled(LED_BLUE);

AnalogIn tempSensor(PTC0); // jumper on board J13 left pin to PTC0 J10-2

int main() {
    float rawVolts;
    float rawTemp;
    float actTemp; //actual temperature
    float FTemp;
    int LEDState = LEDON;
    
    myBled.write(LEDOFF);
    myGled.write(LEDOFF);
    while(true) {
        
        rawTemp = tempSensor.read();//actually percentatd of Vdd volts
        rawVolts = VDD * rawTemp;
        actTemp = REFTEMP + (rawVolts - REFVOLTS)/TEMPSLOPE;
        FTemp = CZERO + actTemp*CFSLOPE;
        pc.printf("RawTemp = %f Actual Ctemp = %5.2f Ftemp = %5.2f\r\n", rawTemp, actTemp, FTemp);
        
        myRled.write(LEDState);
        LEDState = !LEDState;
        wait(DATATIME);
        
    }
}
