
#include "mbed.h"
#include "MAG3110.h"
#include "SLCD.h"
/* 
Test of magnetometer and other sensors on the KL46Z board. Not clear to me at this
time what the conversion factor of the magnetic field values map to.
set up state machine to cycle through what is displayed on the LCD screen. Remember
there are 4 characthers plus a "free" decimal point. - 140721 sc 
*/
#define MESSTIME 0.5
#define BLINKTIME 500
#define DATATIME 200
#define LEDOFF 1
#define LEDON 0
#define MESSAGETIME 0.3
#define LIGHT "LGHT"
#define MAGX_LBL "MAGX"
#define MAGY_LBL "MAGY"
#define BOTIX_LBL "BOTX"

// States
#define NUMSTATES 4
#define L_STATE 0
#define MAGX_STATE 1
#define MAGY_STATE 2
#define BOTIX_STATE 3

#define PROGNAME "MAG v2.0"
#define LPRNAME "MV2.0"

// look at this site for PIN defintions. http://mbed.org/platforms/FRDM-KL46Z/
// #define PRINTDBUG

MAG3110 mag(PTE25, PTE24);

SLCD slcd; //define LCD display
AnalogIn LightSensor(PTE22);
AnalogIn MaxBotix(PTB0);
Serial pc(USBTX, USBRX);
Timer LEDTimer;
Timer DATATimer;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void LCDTMess(char *lMess, float Ddelay){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(Ddelay);
}
int main() {
    DigitalOut Rled(LED_RED);
    DigitalOut Gled(LED_GREEN);
    int displayState = 2; // show magy first on LCD
    int LButtonState;
    DigitalIn LftButton(PTC3);
    int ledState = true;
    float lightValue; //Read from ADC connected to ambient light sensor (photo transistor)
    int magX = 0, magY = 0, magZ = 0; // Magnetic field data
    float MaxBValue;
    char lcdData[10];

// Do once... equivalent to the setup fucntion in the Arduino paradigm
    mag.begin();
// Setup event timers for LED blink and taking magnetometer data
    LEDTimer.start();
    LEDTimer.reset();
    DATATimer.start();
    DATATimer.reset();
  // Show program name LCD and Serial
    pc.printf(PROGNAME);
    LCDTMess(LPRNAME,MESSTIME);
// Do forever... equivalent to the loop fucntion in the Arduino paradigm
    while (true) {
        // read the inverted logic of the left button on the board.
        LButtonState = !LftButton;
        if (LButtonState) {  //Change data that is displayed cycle through states 
            displayState++;
            displayState = displayState % NUMSTATES; // Roll over if greater than the number of states defined
            switch (displayState) {
                case L_STATE: {
                    LCDTMess(LIGHT,MESSTIME);
                    break;
                 }
                 case MAGX_STATE: {
                    LCDTMess(MAGX_LBL,MESSTIME);
                    break;
                 }
                  case MAGY_STATE:{
                    LCDTMess(MAGY_LBL,MESSTIME);
                    break;
                 }
                  case BOTIX_STATE:{
                    LCDTMess(BOTIX_LBL,MESSTIME);
                    break;
                }
                 
            }
        }
// Manage mag and light data
        if (DATATimer.read_ms() > DATATIME){ //take data at DATATIME intervals
            DATATimer.reset();
            lightValue = 1.0-LightSensor.read();  
            mag.getValues(&magX, &magY, &magZ);
            MaxBValue = MaxBotix.read();
            
#ifdef PRINTDBUG
            pc.printf("%f\r\n", lightValue);
            pc.printf("%d\r\n", magX);
            pc.printf("%d\r\n", magY);
            pc.printf("%d\r\n", MaxBotix);
#endif
        
            switch (displayState) {
                case L_STATE: {
                    sprintf (lcdData,"%4.3f",lightValue);
                    break;
                 }
                 case MAGX_STATE: {
                     sprintf (lcdData,"%4d",magX/100);
                    break;
                 }
                 case MAGY_STATE: {
                     sprintf (lcdData,"%4d",magY/10);
                    break;
                 }
                 case BOTIX_STATE:{
                    sprintf (lcdData,"%4.3f",MaxBValue);
                    break;
                 }
            }
            LCDMess(lcdData);
        }
// Manage LED's
        if(LEDTimer.read_ms() > BLINKTIME) { // Blink LED's for dramatic effect.
                LEDTimer.reset();
            ledState = !ledState;
            Rled = ledState;
            Gled = !ledState;
        }
       
    }
}