#include "mbed.h"
#include "SLCD.h"


// An State Machine solution to HW 4.1 Q3
// using wait() for high and low limits.
// Use the idea of a sieve modoel instead of a series of if..then..elseif..
//#define PRINTDEBUG
#define PROGNAME "blink_kl46z_states seive v3\n\r"
#define LEDON false
#define LEDOFF true
#define LEDTMESS "TRUE"
#define LEDFMESS "FALS"
#define BLINKDWELL 400// milliseconds
#define LIMITSTAYON 1000
#define DFDELTA 0.01
#define PWMTIME 1 // ms (kHz
#define LCDLEN 10
#define NUMLIMITS 3
#define BOTTOMLIMIT 0.0
#define LOWLIMIT 0.1
#define HILIMIT 0.85
#define TOPLIMIT 1.1
#define ONTIME 1.0


#define NUMSTATES 4
#define IDLESTATE 0
#define NEWBLINK 1
#define LOWLITE 2
#define HILITE 3
int stateArray[NUMSTATES] = {HILITE, NEWBLINK, LOWLITE,IDLESTATE};
float lightLimits[NUMLIMITS] = {HILIMIT, LOWLIMIT, BOTTOMLIMIT};

char logicalString [NUMSTATES][LCDLEN] = {LEDFMESS, LEDTMESS};
SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

int main() {
    DigitalOut greenColor(LED_GREEN);
    DigitalOut redColor(LED_RED);
    AnalogIn LightSensor(PTE22);
    float lightData; 
    char lcdData[LCDLEN];
    Timer LEDTimer;  // time till next PWM values is to change.
    int PGMState = IDLESTATE; // work till timer transitions
    int ledState = LEDON;  
    int i;
   
    int timeToChangeDF = BLINKDWELL;
    // set up timer for next step of Duty Factor timing
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);
    
    greenColor.write(LEDON);
    redColor.write(LEDON);
    
    while(true) {
        while(LEDTimer.read_ms() > timeToChangeDF){// check for timer time out transtion
            switch (PGMState){ 
                case IDLESTATE: {
                    lightData = (1.0 - LightSensor.read());
                    sprintf(lcdData,"%4.3f",lightData);
                    LCDMess(lcdData);  
                    timeToChangeDF = BLINKDWELL;
                    LEDTimer.reset();  // reset the timer
                    // put data throuth the sieve.
                    i=0;//start sieve
                    while((lightData < lightLimits[i])&& (i < NUMLIMITS)){
                        i++;
                    }
                    PGMState = stateArray[i];
                    break;
                }
                case  NEWBLINK: {              
                    redColor.write(ledState);
                    greenColor.write(!ledState);
                    ledState = !ledState;
                    // create string for display on LCD
                    timeToChangeDF = BLINKDWELL;            
                    LEDTimer.reset();  // reset the timer
                    PGMState = IDLESTATE;  // go idle state
                    break;
                }
                case HILITE: {              
                    redColor.write(LEDON);
                    greenColor.write(LEDOFF);
                    timeToChangeDF = LIMITSTAYON;
                
                    LEDTimer.reset();  // reset the timer
                    PGMState = IDLESTATE;  // go idle state
                    break;
                }
                case LOWLITE: {              
                    redColor.write(LEDOFF);
                    greenColor.write(LEDON);
                    timeToChangeDF = LIMITSTAYON;
                    // create string for display on LCD
                    LEDTimer.reset();  // reset the timer
                    PGMState = IDLESTATE;  // go idle state
                    break;
              }
            } // end state machine
        }// end timer while       
    }// end  foreever while
}
