#include "mbed.h"
#include "SLCD.h"


// An State Machine solution to HW 4.1 Q3
// using wait() for high and low limits.
//#define PRINTDEBUG
#define PROGNAME "blink_kl46z_states nowait v1\n\r"
#define LEDON false
#define LEDOFF true
#define LEDTMESS "TRUE"
#define LEDFMESS "FALS"
#define BLINKDWELL 400 // milliseconds
#define LIMITSTAYON 1000
#define DFDELTA 0.01
#define PWMTIME 1 // ms (kHz
#define LCDLEN 10
#define NUMSTATES 2
#define LOWLIMIT 0.1
#define HILIMIT 0.85
#define ONTIME 1.0


enum blinkStates {IDLESTATE, NEWBLINK, LOWLITE, HILITE}; // define the states

char logicalString [NUMSTATES][LCDLEN] = {LEDFMESS, LEDTMESS};
SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

int main() {
    DigitalOut greenColor(LED_GREEN);
    DigitalOut redColor(LED_RED);
    AnalogIn LightSensor(PTE22);
    float lightData; 
    char lcdData[LCDLEN];
    Timer LEDTimer;  // time till next PWM values is to change.
    blinkStates PGMState = IDLESTATE; // work till timer transitions
    int ledState = LEDON;  
    
   
    int timeToChangeDF = BLINKDWELL;
    // set up timer for next step of Duty Factor timing
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);
    
    

    while(true) {
        switch (PGMState){ 
            case IDLESTATE: {
                if (LEDTimer.read_ms() > timeToChangeDF){ // check for timer time out transtion
                    lightData = (1.0 - LightSensor.read());
                    sprintf(lcdData,"%4.3f",lightData);
                    LCDMess(lcdData);  
                    timeToChangeDF = BLINKDWELL;
                    if (lightData < LOWLIMIT){ // find appropriate state
                        PGMState = LOWLITE;
                        timeToChangeDF = LIMITSTAYON;
                    } else if (lightData > HILIMIT){
                        PGMState = HILITE;
                        timeToChangeDF = LIMITSTAYON;
                    } else {
                        PGMState = NEWBLINK;
                        timeToChangeDF = BLINKDWELL;
                    }                      
                    
                }
                break;
              }
             case  NEWBLINK: {              
                ledState = !ledState;
                redColor.write(ledState);
                greenColor.write(!ledState);
                // create string for display on LCD
                             
                LEDTimer.reset();  // reset the timer
                PGMState = IDLESTATE;  // go idle state
                break;
              }
             case HILITE: {              
                redColor.write(LEDON);
                greenColor.write(LEDOFF);
                // create string for display on LCD
                if (LEDTimer.read_ms() > timeToChangeDF){     
                    LEDTimer.reset();  // reset the timer
                    PGMState = IDLESTATE;  // go idle state
                }
                break;
              }
             case LOWLITE: {              
                redColor.write(LEDOFF);
                greenColor.write(LEDON);
                // create string for display on LCD
                if (LEDTimer.read_ms() > timeToChangeDF){     
                    LEDTimer.reset();  // reset the timer
                    PGMState = IDLESTATE;  // go idle state
                }
                break;
              }
        } // end state machine
        
#ifdef PRINTDEBUG
        pc.printf("i= %d dutyfactor = %5.4f workingDelta %5.4f \n\r",  i, dutyFactor, workingDelta); 
#endif
    }// emd while
}
