#include "mbed.h"
#include "SLCD.h"


#define PROGNAME "lightsense_kl46z_PWM v1\n\r"
#define DATATIME 400 // milliseconds
#define LCDLEN 10
#define LIGHTSENSORPORT PTE22
#define LUXSCALING 1650 // full scale lux 500 lux/volt
#define LIMTMESSAGE "OVER"
#define FULLSCALE  1000.0



SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);
Timer LEDTimer;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

int main() {
    PwmOut greenColor(LED_GREEN);
    PwmOut redColor(LED_RED);
    AnalogIn LightSensor(LIGHTSENSORPORT);
    float lightData; 
    float luxData;
    char lcdData[LCDLEN];
   
    int timeToChangeDF = DATATIME;
    // set up timer for next step of Duty Factor timing
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);
    
    
    while(true) {    
        if (LEDTimer.read_ms() > timeToChangeDF){ // check for timer time out transtion
            // start out assuming over 1000 lux
            sprintf(lcdData,"%s",LIMTMESSAGE);
            lightData = (1.0 - LightSensor.read()); // show as increasiing with increasing intensity
            luxData = lightData * LUXSCALING;
            
            greenColor.write(1.0- lightData);
            redColor.write(1.0-lightData);
            if( luxData < FULLSCALE){
                sprintf(lcdData,"%4.0f",luxData);
            }    
            LCDMess(lcdData);  
            pc.printf("%4.3f" "%4.0f\r\n",lightData,luxData);
            timeToChangeDF = DATATIME;
            LEDTimer.reset();
        }        
    }// emd while
}
