#include "mbed.h"
#define PROGNAME "Light_Sense_v1\n\r"
#define DATATIME 0.5

#define PRINTDEBUG

AnalogIn LightSensor(PTE22); // define light sensor
PwmOut redLed(LED_RED);

Serial pc(USBTX, USBRX);

int main()
{
    float lightVal;
    unsigned short lightWord;

    pc.printf(PROGNAME);
    
    while (true) {
        lightVal = LightSensor.read();
        lightWord = LightSensor.read_u16();
        redLed = lightVal;
#ifdef PRINTDEBUG
        pc.printf("LS => %1.3f %5d \r\n", lightVal, lightWord);
#endif
        wait(DATATIME);
    }
}