#include "mbed.h"
#include <math.h>  
#include "TSISensor.h"
#include "SLCD.h"
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define TSILIMIT 0.99
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.3
#define LCDTIME 0.250
#define NUMMESS 2
#define NUMBUTS 2
#define FLOATDISP 0
#define UINTDISP 1
#define BITS16 65536
#define SHIFT2NUMERALS 100 // divide for right shift -  modul
#define RETAIN3NUMERALS 1000 // modulo (%) 1000


#define LIGHTSENSORPORT PTE22
#define PROGNAME "kl46z_slider_lightsense\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

// define I/O
PwmOut gled(LED_GREEN);
PwmOut rled(LED_RED);
TSISensor tsi;

DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
AnalogIn LightSensor(LIGHTSENSORPORT);
Timer ButtonTimer; // for reading button states
Timer LCDTimer;
Timer dataTimer;

// definie an enum for illustration purposes
    enum shiftstate_t {right, none, left};

int displayState = FLOATDISP;

unsigned int leftrigntStateMachine( shiftstate_t sState, unsigned int usenseData ){
    unsigned int dataReturn;
    
    // data shifter state machine
    
    switch(sState) { 
        case none: {
                dataReturn = usenseData;
                break;
                }
        case right: {
                dataReturn = usenseData / SHIFT2NUMERALS;
                break;
                }
        case left: {
                dataReturn = usenseData % RETAIN3NUMERALS;
                break;
                }
    } // end switch shiftstate 
    return (dataReturn);
}

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timer
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset(); 
    LCDTimer.start();
    LCDTimer.reset(); 
     
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

int main(void) {
    int i;
    unsigned int dataRemainder;

    char lcdData[LCDCHARLEN];
    float tempTouch;
    float lastTouch = 0.0;
    float tsidata = 0.0;
    float lightData;
    unsigned int ulightData;
    float shiftResult;
    
    shiftstate_t shiftstate = none;

    
    
    initialize_global_vars();

     while (true) {
        // read buttons
        if (ButtonTimer.read() > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    displayState = i;
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
        }
        
        // Read touch sensor
        if(dataTimer.read() > DATAINTERVAL){
            tempTouch = tsi.readPercentage();
            dataTimer.reset();  
            shiftResult = tempTouch -lastTouch;
            if (tempTouch > TSILIMIT){
                gled.write(0.0);// turn them off
                rled.write(0.0);
            }else {
                if (fabs(shiftResult) < PRINTDELTA) {
                    shiftstate = none; 
                    
                } else if (shiftResult < 0.0 ) {
                        shiftstate = left;
                      
                } else {
                        shiftstate = right;                   
                }
                /*
                if (fabs(shiftResult)> PRINTDELTA){                
                    pc.printf("Position %0.4f\n\r", tsidata);
                }
                */
                tsidata= tempTouch;
                gled.write(tsidata);
                rled.write(1.0 - tsidata);
                lastTouch=tsidata;
            }  
        }
        if(LCDTimer.read() > LCDTIME){
            LCDTimer.reset();                               
            switch (displayState){
                case FLOATDISP: {
                    lightData = (1.0 - LightSensor.read()); // show as increasiing with increasing intensity  
                    sprintf(lcdData,"%4.3f",lightData); 
                    break;
                }
                case UINTDISP: {
                    ulightData = BITS16 - LightSensor. read_u16();  
                    dataRemainder = leftrigntStateMachine( shiftstate, ulightData);
                    sprintf(lcdData,"%4d",dataRemainder); 
                    break;
                }// end switch displaystate
            }                 
            LCDMess(lcdData); 
        } // end LCD timer.read
            
    }// end while(true)
}