#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"


#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define RBUTINDEX 0
#define LBUTINDEX 1
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define DATATIME    200 //milliseconds
#define LCDLEN      10
#define PROGNAME "kl46z_btn_slider_toSerial\r\n"

// Cap slider interface
SLCD slcd; //define LCD display

TSISensor tsiScaling; // Capacitive sensor/slider
Timer dataTimer;

// Button interrrupts
InterruptIn rtButton(RBUT);
InterruptIn lfButton(LBUT); 

char lcdData[LCDLEN];

Serial pc(USBTX, USBRX);// set up USB as communications to Host PC via USB connectons
 
// Interrupt service routines
void rtButtonPressed(){
    pc.printf("button: right\r\n");
}

void lfButtonPressed(){
    pc.printf("button: left \r\n");
}
        
// End interrupt routines

// Regular routines
void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

// --------------------------------
 int main() {
    float sliderValue = 0.0;
    
    pc.printf(PROGNAME);
    dataTimer.start();
    dataTimer.reset(); 
    sprintf (lcdData,"%4.3f",0.0);
    LCDMessNoDwell(lcdData);
    
// Interrupt routine setups
    rtButton.fall(&rtButtonPressed);
    lfButton.fall(&lfButtonPressed);
    
// End of setup

    while(true) {
    // All the interrupts
        
        if (dataTimer.read_ms() > DATATIME){
            // Read the slider value
            float newSliderValue = tsiScaling.readPercentage();
            // Only do stuff with it if it's a new value or if it's not zero
            if(newSliderValue > 0.0 && newSliderValue != sliderValue) {
                sliderValue = newSliderValue;
                sprintf (lcdData,"%4.3f", sliderValue);  // Just to make things user readable
                
                LCDMessNoDwell(lcdData);
                pc.printf("slider: %4.3f\r\n", sliderValue);
            }
            dataTimer.reset(); 
        }   
      
    }
}