#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"

#define BASESPEED   1.200
#define DOT         1
#define DASH        3
#define INTERCHAR   3
#define CHANNELON   0
#define CHANNELOFF  1
#define LCDLEN      10
#define DOTMESS     "DIT"
#define DASHMESS    "DAH"
#define IAMMESS     "IAMB"
#define NULLMESS    "111"  // LCD idle message
#define FIXEDWPM    13
#define LOWSPEED    5
#define SPPEDINT    25.0 // This gives a max speed of 30 - 5 + 25

#define STATECOEF   2
#define IDLE        0
#define DIT         1
#define DAH         2
#define IAM         3
#define SIDETONE    0.0014  //seconds
#define TONEON      0.50
#define TONEOFF     0.0

SLCD slcd; //define LCD display
// keyer test
TSISensor tsiScaling; // Capacitive sensor/slider
DigitalIn RtButton(PTC12);
DigitalIn LftButton(PTC3);
DigitalIn DahPaddle(PTD7);
DigitalIn DitPaddle(PTD6);
DigitalOut led(LED_RED);
DigitalOut outPin(PTC9); //J1-16
PwmOut soundOut(PTC9);
int KeyState = IDLE;


void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void makeDit (float dotLen,DigitalOut outChannel, DigitalOut cloneChannel) {
    outChannel.write(CHANNELON);
    cloneChannel.write(CHANNELON);
    soundOut.write(TONEON);
    wait(dotLen);
    outChannel.write(CHANNELOFF);
    cloneChannel.write(CHANNELOFF);
    soundOut.write(TONEOFF);
    wait(float(DOT)*dotLen);
    return;
}
    
void makeDah (float dotLen,DigitalOut outChannel, DigitalOut cloneChannel) {
    outChannel.write(CHANNELON);
    cloneChannel.write(CHANNELON);
    soundOut.write(TONEON);
    wait(float(DASH)*dotLen);
    outChannel.write(CHANNELOFF);
    cloneChannel.write(CHANNELOFF);
    soundOut.write(TONEOFF);
    wait(float(DOT)*dotLen);
    return;
}


int main(){
    int wpm = FIXEDWPM;
    float elementLen;  // period in seconds
    int RButtonState;
    int LButtonState;
    int DahPaddleState;
    int DitPaddleState;
    char lcdData[LCDLEN];
    float tempValue;
    int lastKeyHit = DIT;
    
    soundOut.period(SIDETONE);
    
    
    elementLen = BASESPEED / (float) wpm;
    
    led.write(CHANNELOFF);
    outPin.write(CHANNELOFF);
    sprintf (lcdData,"%d",wpm);
    LCDMessNoDwell(lcdData);
    
    
    while (true) {
    /*
        RButtonState = !RtButton.read(); // button is pulled up so false is when button is pushed it's inverted to avoid confusion downstream
        if (RButtonState){
           KeyState = DAH;  
        }
        LButtonState = !LftButton.read();
        if (LButtonState) {
            KeyState = DIT;
        }        
    */
       RButtonState = !RtButton.read();
       LButtonState = !LftButton.read();
       DahPaddleState =!DahPaddle.read();
       DitPaddleState = !DitPaddle.read();
       KeyState = LButtonState + STATECOEF*RButtonState;
       KeyState = KeyState + DitPaddleState + STATECOEF*DahPaddleState;
        
        switch (KeyState) {
            case DAH:{
                LCDMessNoDwell(DASHMESS);
                makeDah(elementLen,outPin,led);
                KeyState = IDLE; 
                lastKeyHit = DAH;
                sprintf (lcdData,"%d",wpm);
                LCDMessNoDwell(lcdData); 
                break;     
            }
            case DIT:{
                LCDMessNoDwell(DOTMESS);
                makeDit(elementLen,outPin,led);             
                KeyState = IDLE;
                lastKeyHit = DIT;
                sprintf (lcdData,"%d",wpm);
                LCDMessNoDwell(lcdData); 
                break;
            }
            case IAM:{
                LCDMessNoDwell(IAMMESS);
                if (lastKeyHit == DAH){;
                    makeDit(elementLen,outPin,led);  
                    makeDah( elementLen,outPin,led);
                    lastKeyHit = DAH;  
                }  else {
                    makeDah(elementLen,outPin,led);  
                    makeDit(elementLen,outPin,led);
                    lastKeyHit = DIT;  
                }      
                KeyState = IDLE;
                sprintf (lcdData,"%d",wpm);
                LCDMessNoDwell(lcdData); 
                break;
            }
            case IDLE:{
                tempValue = tsiScaling.readPercentage();
                if(tempValue > 0) {
                    wpm =  LOWSPEED + int(tempValue * SPPEDINT);
                    elementLen = BASESPEED / (float) wpm;
                    sprintf (lcdData,"%d",wpm);
                    LCDMessNoDwell(lcdData);
                }             
                break;
            }
        } 
         
    } // while forever
}// end main