
#include "mbed.h"
#include "MAG3110.h"
#include "SLCD.h"
#include "TSISensor.h"
/* 
Test of magnetometer and other sensors on the KL46Z board. Not clear to me at this
time what the conversion factor of the magnetic field values map to.
set up state machine to cycle through what is displayed on the LCD screen. Remember
there are 4 characthers plus a "free" decimal point. - 140721 sc 
*/
#define MESSTIME 0.5
#define BLINKTIME 200 // ms offset
#define BLINKMAX 1000 // touch sensor returns 0 - 0.99
#define DATATIME 200
#define LEDOFF 1
#define LEDON 0
#define MESSAGETIME 0.3
#define LIGHT "LGHT"
#define MAGX_LBL "MAGX"
#define MAGY_LBL "MAGY"
#define BOTIX_LBL "ANIN"
#define ONEORDER 10
#define TWOORDERS 100
#define NULLVAL 20

// States
#define NUMSTATES 4
#define L_STATE 0
#define MAGX_STATE 1
#define MAGY_STATE 2
#define BOTIX_STATE 3

#define PROGNAME "FIBBO v1\r\n"
#define LPRNAME "MV2.0"

// look at this site for PIN defintions. http://mbed.org/platforms/FRDM-KL46Z/
// #define PRINTDBUG

MAG3110 mag(PTE25, PTE24);

SLCD slcd; //define LCD display
AnalogIn LightSensor(PTE22);
AnalogIn MaxBotix(PTB0);
Serial pc(USBTX, USBRX);
Timer LEDTimer;
Timer DATATimer;
TSISensor tsiScaling; // Capacitive sensor/slider

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void LCDTMess(char *lMess, float Ddelay){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(Ddelay);
}
// insert fibonacci here
float fibbo( int fib_stop){
    int Fnm_1=0;
    int Fn = 1;
    float phi_n = 0.0;
    int Fnext;
    float phi_n_1 = 0.0; //# keep the previous phi
    int fib_counter = 2; // # minimum counts
    float epsilon = 1e-7;
    float delta_phi = 0.0;
    //  fib_stop = int(input('Stop at element number: n= '))
    if (fib_stop < fib_counter){
        pc.printf(" -> %d \n\r",Fnm_1);
        pc.printf(" -> %d \n\r",Fn);
    }
    while (fib_stop > fib_counter){
        Fnext = Fn + Fnm_1;
        phi_n = (float)(Fnext) / (float)(Fn);
        delta_phi = abs(phi_n - phi_n_1);
        pc.printf("%d - %d, %f, %e\r\n ",fib_counter, Fnext, phi_n, delta_phi);
        if (epsilon > delta_phi){
            break;
        }
        Fnm_1 = Fn;
        Fn = Fnext;
        phi_n_1 = phi_n; //# stor the previous phi for comparison
        fib_counter++;
    }
     pc.printf("Done\r\n");
     return(fib_stop);
}

int main() {
    DigitalOut Rled(LED_RED);
    DigitalOut Gled(LED_GREEN);
    int displayState = 2; // show magy first on LCD
    int LButtonState;
    DigitalIn LftButton(PTC3);
    int ledState = true;
    float lightValue; //Read from ADC connected to ambient light sensor (photo transistor)
    int magX = 0, magY = 0, magZ = 0; // Magnetic field data
    float MaxBValue;
    char lcdData[10];
    int magXVal;
    int nullState = false;
    float touchValue = 0.0;
    float tempValue;
    int LEDTime = BLINKTIME;

// Do once... equivalent to the setup fucntion in the Arduino paradigm
    mag.begin();
// Setup event timers for LED blink and taking magnetometer data
    LEDTimer.start();
    LEDTimer.reset();
    DATATimer.start();
    DATATimer.reset();
  // Show program name LCD and Serial
    pc.printf(PROGNAME);
    LCDTMess(LPRNAME,MESSTIME);
    // insert call to fibbon

    fibbo(30);
    
// Do forever... equivalent to the loop fucntion in the Arduino paradigm
    while (true) {
        tempValue = tsiScaling.readPercentage();
        if(tempValue > 0) touchValue = tempValue;
        // read the inverted logic of the left button on the board.
        LButtonState = !LftButton;
        if (LButtonState) {  //Change data that is displayed cycle through states 
            displayState++;
            displayState = displayState % NUMSTATES; // Roll over if greater than the number of states defined
            switch (displayState) {
                case L_STATE: {
                    LCDTMess(LIGHT,MESSTIME);
                    break;
                 }
                 case MAGX_STATE: {
                    LCDTMess(MAGX_LBL,MESSTIME);
                    break;
                 }
                  case MAGY_STATE:{
                    LCDTMess(MAGY_LBL,MESSTIME);
                    break;
                 }
                  case BOTIX_STATE:{
                    LCDTMess(BOTIX_LBL,MESSTIME);
                    break;
                }
                 
            }
        }
// Manage mag and light data
        if (DATATimer.read_ms() > DATATIME){ //take data at DATATIME intervals
            DATATimer.reset();
            lightValue = 1.0-LightSensor.read();  
            mag.getValues(&magX, &magY, &magZ);
            MaxBValue = MaxBotix.read();
            
#ifdef PRINTDBUG
            pc.printf("%f\r\n", lightValue);
            pc.printf("%d\r\n", magX);
            pc.printf("%d\r\n", magY);
            pc.printf("%d\r\n", MaxBotix);
#endif
        
            switch (displayState) {
                case L_STATE: {
                    sprintf (lcdData,"%4.3f",lightValue);
                    break;
                 }
                 case MAGX_STATE: {
                     magXVal =abs(magX)/ONEORDER;
                     nullState = (magXVal < NULLVAL);
                     sprintf (lcdData,"%4d",magXVal);
                    break;
                 }
                 case MAGY_STATE: {
                     sprintf (lcdData,"%4d",magY);
                    break;
                 }
                 case BOTIX_STATE:{
                    sprintf (lcdData,"%4.3f",MaxBValue);
                    break;
                 }
            }
            LCDMess(lcdData);
        }
// Manage LED's
        if(LEDTimer.read_ms() > LEDTime) { // Blink LED's for dramatic effect.
            LEDTime = BLINKTIME + (int)(touchValue*BLINKMAX);
            LEDTimer.reset();
            if (nullState){
                Rled =LEDON;
                Gled = LEDON;
            } else {
                ledState = !ledState;
                Rled = ledState;
                Gled = !ledState;
            }
        }
       
    }
}