#include "mbed.h"
#include "SLCD.h"


// An example of C++ abuse 140904 sc
//#define PRINTDEBUG
#define PROGNAME "blink_kl46z_states v1\n\r"
#define LEDON false
#define LEDOFF true
#define LEDTMESS "TRUE"
#define LEDFMESS "FALS"
#define BLINKDWELL 400 // milliseconds
#define DFDELTA 0.01
#define PWMTIME 1 // ms (kHz
#define LCDLEN 10
#define NUMSTATES 2
#define NEWBLINK 1
#define IDLESTATE 0

char logicalString [NUMSTATES][LCDLEN] = {LEDFMESS, LEDTMESS};
SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

int main() {
    DigitalOut greenColor(LED_GREEN);
    DigitalOut redColor(LED_RED);
    char lcdData[LCDLEN];
    Timer LEDTimer;  // time till next PWM values is to change.
    int PGMState = IDLESTATE; // work till timer transitions
    int ledState = LEDON;  
    
   
    int timeToChangeDF = BLINKDWELL;
    // set up timer for next step of Duty Factor timing
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);
    
    

    while(true) {
        switch (PGMState){ 
            case IDLESTATE: {
                if (LEDTimer.read_ms() > timeToChangeDF){ // check for timer time out transtion
                    PGMState = NEWBLINK;
                    }
                break;
              }
             case  NEWBLINK: {              
                ledState = !ledState;
                redColor = ledState;
                greenColor = !ledState;
                sprintf(lcdData,logicalString[ledState]);
                LCDMess(lcdData);               
                LEDTimer.reset();  // reset the timer
                PGMState = IDLESTATE;  // go idle state
                break;
              }
        } // end state machine
        
#ifdef PRINTDEBUG
        pc.printf("i= %d dutyfactor = %5.4f workingDelta %5.4f \n\r",  i, dutyFactor, workingDelta); 
#endif
    }// emd while
}
