#include "mbed.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define PWMDWELL 50 // milliseconds
#define DFDELTA 0.01
#define PWMTIME 1 // ms (kHxz
#define LCDLEN 10

// slightly more interesting blinky 140814 sc
// Change to use PWM

float dutyFactor = 0.0;
PwmOut greenColor(LED_GREEN);
PwmOut redColor(LED_RED);
SLCD slcd; //define LCD display

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

int main() {
    char lcdData[LCDLEN];
    greenColor.period_ms(PWMTIME); // set the frequency of the pulse train
    redColor.period_ms(PWMTIME);
    float workingDelta = DFDELTA;
    int numSteps;
    int i;
    
    numSteps = (int)(1.0/DFDELTA);
    while(true) {
        for (i = 0; i < numSteps; i++){
            redColor.write(dutyFactor);
            greenColor.write(1.0 - dutyFactor);
            dutyFactor += workingDelta;
//        if(dutyFactor >= 1.0) workingDelta = -workingDelta;
//        if(dutyFactor < DFDELTA) workingDelta = DFDELTA; // could be done another way
            sprintf (lcdData,"%4.3f",dutyFactor);  
            LCDMess(lcdData);  
            wait_ms(PWMDWELL);
        }
        workingDelta = -workingDelta;
    }
}