#include "mbed.h"
#include "SLCD.h"

#define PROGNAME "blink_freq_select interrupt"
#define LEDON false
#define LEDOFF true
#define PWMDWELL 50 // milliseconds
#define DFDELTA 0.01
#define PWMTIME 1 // ms (kHz
#define LCDLEN 10
#define NUMPER 5
#define PWMPERIODS {1,2,10,20,50} // ms - frequencies 1kHz, 500Hz

// slightly more interesting blinky 140814 sc
// Change to use PWM

int perdStates[NUMPER] = PWMPERIODS;
float dutyFactor = 0.0;

int selectState = 0; // note this change will be incremented in interrupt routine
bool updateFlag = false;

PwmOut greenColor(LED1);
PwmOut redColor(LED2);
InterruptIn rtButton(PTC3); // Big change.
// DigitalIn rightButton(PTC3);
SLCD slcd; //define LCD display


// interrupt routine keep very short This may be pushing it
void rtButtonPressed(){
    selectState = (selectState + 1) %  NUMPER;
    greenColor.period_ms(perdStates[selectState]); // set the frequency of the pulse train
    redColor.period_ms(perdStates[selectState]);
    updateFlag = true;
}

// end interuurp
void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

int main() {
    char lcdData[LCDLEN];
    greenColor.period_ms(PWMTIME); // set the frequency of the pulse train
    redColor.period_ms(PWMTIME);
    float workingDelta = DFDELTA;
    int numSteps;
    // Note this had moved to global - int selectState = 0; // start at 1kHz
    int i;
    
    numSteps = (int)(1.0/DFDELTA);
    sprintf (lcdData,"%4d",perdStates[selectState]);  
    LCDMess(lcdData);  
    
    // set up interrupt
     rtButton.fall(&rtButtonPressed);
     
    while(true) {
        for (i = 0; i < numSteps; i++){
            redColor.write(dutyFactor);
            greenColor.write(1.0 - dutyFactor);
            dutyFactor += workingDelta;  
            if (updateFlag){  // time to update the display?
                sprintf (lcdData,"%4d",perdStates[selectState]);  
                LCDMess(lcdData);  
                updateFlag = false;
            }      
            wait_ms(PWMDWELL);
        }
        workingDelta = -workingDelta;
    }
}