#include "mbed.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define BLINKTIME 0.3 // in seconds
#define BUTTONTIME 0.2
#define LCDCHARLEN 10
#define NUMMESS 2

#define PROGNAME "blink_kl46z_buttton no wait\r\n"

// Timer to elliminate wait() function
Timer LEDTimer; // for blinking LEDs
Timer ButtonTimer; // for reading button states

bool ledState = LEDON;

DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};
Serial pc(USBTX, USBRX);// set up USB as communicationis to Host PC via USB connectons

void allLEDsOff(){
    int i;
    for (i=0; i<NUMBUTS; i++){ 
        LEDs[i] = LEDOFF;    
    }
}
 

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    LEDTimer.start();
    LEDTimer.reset();  
    allLEDsOff();
} 
// --------------------------------
 int main() {
    int i; 
    int currentLED = 0;
    
    initialize_global_vars(); //keep things organized
    LEDs[currentLED] = LEDON;
// End of setup

    while(true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) { 
                    allLEDsOff();  
                    currentLED = i;
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
        }
        if(LEDTimer.read() > BLINKTIME){
            LEDTimer.reset();               
            ledState = !ledState; // Flip the general state
            LEDs[currentLED] = ledState;
        }
    // Do other things here between times of reading and flashing
    }
}