#include "mbed.h"
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define BUTDOWN false
#define BUTUP true
#define NUMBUTS 2
#define LBUT PTC12
#define RBUT PTC3
#define BLINKTIME 0.3
#define REDMESS "RED LED is ON\r\n" // adding  DR and line feed for terminal line advance
#define LCDCHARLEN 10
#define NUMMESS 2
#define LRED "RED"
#define LGREEN "GREN"
#define PRED "RED\r\n"
#define PGREEN "GREEN\r\n"
#define PROGNAME "blink_kl46z_buttton LCD v1\r\n"

// slightly more interesting blinky 140814 sc
SLCD slcd; //define LCD display


int ledState = LEDON;
int buttonStates[NUMBUTS] = {BUTDOWN,BUTUP};
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};
Serial pc(USBTX, USBRX);// set up USB as communicationis to Host PC via USB connectons

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

// --------------------------------
int main() {
    int i; 
    int currentLED = 0;
    char rMess[NUMMESS][LCDCHARLEN]={LGREEN, LRED};
    char pMess[NUMMESS][LCDCHARLEN]={PRED, PGREEN};
    pc.printf(PROGNAME);
    
    LCDMess(rMess[currentLED]);
    pc.printf(pMess[currentLED]);
    while(true) {
        for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1
            LEDs[i] = LEDOFF;      
            // if(buttons[i] == BUTDOWN) {
            if(!buttons[i]) {
                 LCDMess(rMess[i]);
                 pc.printf(pMess[i]); // this means that RED will be blinking
                currentLED = i;
            }
        }
                
        ledState = !ledState; // Flip the general state
        LEDs[currentLED] = ledState;
        wait(BLINKTIME);
    }
}