#include "mbed.h"
#define LEDON false
#define LEDOFF true
#define BUTDOWN false
#define BUTUP true
#define NUMBUTS 2
#define LBUT PTC12
#define RBUT PTC3
#define BLINKTIME 0.3
#define REDMESS "RED LED is ON\r\n" // adding  DR and line feed for terminal line advance
#define PROGNAME "blink_kl46z_buttton v1\r\n"

// slightly more interesting blinky 140814 sc


int ledState = LEDON;
int buttonStates[NUMBUTS] = {BUTDOWN,BUTUP};
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};
Serial pc(USBTX, USBRX);// set up USB as communicationis to Host PC via USB connectons

// --------------------------------
int main() {
    int i; 
    int currentLED = 0;
    pc.printf(PROGNAME);
    while(true) {
        for (i=0; i<NUMBUTS; i++){
            LEDs[i] = LEDOFF;      
            if(buttons[i] == BUTDOWN) {
                // red LED has an index of 1 see line 17
                if (i == 1) pc.printf(REDMESS); // this means that RED will be blinking
                currentLED = i;
            }
        }
                
        ledState = !ledState; // Flip the general state
        LEDs[currentLED] = ledState;
        wait(BLINKTIME);
    }
}