#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"


#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define RBUTINDEX 0
#define LBUTINDEX 1
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define BLINKTIME 0.3 // in seconds
#define DATATIME    50 //milli seccnds
#define LCDLEN      10
#define PROGNAME "blink_kl46z_buttton interrupt slider\r\n"

// Cap slider interface
SLCD slcd; //define LCD display

TSISensor tsiScaling; // Capacitive sensor/slider
Timer dataTimer;

// Timer to elliminate wait() function
// Timer LEDTimer; // for blinking LEDs
Ticker Blinker;

//Timer ButtonTimer; // no longer needed
// Button interrrupts
InterruptIn rtButton(RBUT); // Big change.
InterruptIn lfButton(LBUT); 

char lcdData[LCDLEN];
bool ledState = LEDON;
int currentLED = 0;  // used in LEDBliker interrupt 

// DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};  This array paradigm will not work right now.
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};
Serial pc(USBTX, USBRX);// set up USB as communicationis to Host PC via USB connectons

void allLEDsOff(){
    int i;
    for (i=0; i<NUMBUTS; i++){ 
        LEDs[i] = LEDOFF;    
    }
}
 
// Interrupt service routines

void rtButtonPressed(){
    allLEDsOff();  
    currentLED = RBUTINDEX;
}

void lfButtonPressed(){
    allLEDsOff();  
    currentLED = LBUTINDEX;
}

void LEDBlinker(){           
            ledState = !ledState; // Flip the general state
            LEDs[currentLED] = ledState;
        }
        
// End interrupt routines

// Regular routines
void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 


void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    allLEDsOff();
} 
// --------------------------------
 int main() {
    float sliderValue=0.0;
    // int currentLED = 0;  needs to be gobal for interrupt routine
    
    initialize_global_vars(); //keep things organized
    LEDs[currentLED] = LEDON;
    dataTimer.start();
    dataTimer.reset(); 
    sprintf (lcdData,"%4.3f",0.0);
    LCDMessNoDwell(lcdData);
    
// Interrupt routine setups
    Blinker.attach(&LEDBlinker, BLINKTIME);
    rtButton.fall(&rtButtonPressed);
    lfButton.fall(&lfButtonPressed);
    
// End of setup

    while(true) {
    // All in the interrupts
        
    // Do other things here between times of reading and flashing
    // OK
    sliderValue = tsiScaling.readPercentage();
        if (dataTimer.read_ms() > DATATIME){
            if(sliderValue > 0.0) {
                sprintf (lcdData,"%4.3f",sliderValue);  // Just to amke things user readable
                LCDMessNoDwell(lcdData);
            }
            dataTimer.reset(); 
        }   
      
    }
}