#include "mbed.h"
#include "SLCD.h"
 
#define LEDON false
#define LEDOFF true
#define LCDCHARLEN 10
#define NUMMESS 2
#define ONEL "   .1"
#define TWOL "2."
 
// slightly more interesting blinky 140814 sc
SLCD slcd; //define LCD display
 
float blinks[]={0.400, 0.700};
int ledState = LEDON;
DigitalOut greenColor(LED_GREEN);
DigitalOut redColor(LED_RED);
int lcdCounter = 1;
 
void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}
//--------------------------------
int main() {
    char rMess[NUMMESS][LCDCHARLEN]={ONEL, TWOL};
 
    
    while(true) {
        lcdCounter++;
        lcdCounter = lcdCounter % NUMMESS;
        ledState = !ledState; // Flip the general state
        redColor = ledState;
        greenColor = !ledState;// flip state but don't store it.
        redColor.write(ledState);
        greenColor.write(!ledState);// flip state but don't store it.
        LCDMess(rMess[lcdCounter]);
        wait(blinks[ledState]);
    }
}
