#include "mbed.h"
#define LEDON false
#define LEDOFF true
#define PWMDWELL 50// milliseconds
#define DFDELTA 0.01

// slightly more interesting blinky 140814 sc
// Change to use PWM

float dutyFactor = 0.0;
PwmOut greenColor(LED_GREEN);
PwmOut redColor(LED_RED);

int main() {
    while(true) {
        redColor.write(dutyFactor);
        greenColor.write(1.0 - dutyFactor);
        dutyFactor += DFDELTA; 
        if(dutyFactor >= 1.0) dutyFactor = 0.0;  
        wait_ms(PWMDWELL);
    }
}