#include "mbed.h"

#define DATATIME 250 // 250 milliseconds
#define LASTDGDIV 10
#define PROGMANE "Analog Rand v1\n\r"

AnalogIn analogRand(PTB0);

DigitalOut Rled(LED_RED);
Serial pc(USBTX, USBRX);

int main(){
  float analogValue;
  unsigned int analogBits;
  unsigned int lastDigit;
  
    while (true) {
        analogValue = analogRand.read();
        analogBits = analogRand.read_u16();
        lastDigit = analogBits % LASTDGDIV; 
        Rled = !Rled; // toggle led
        pc.printf("%0.5f, %d, %1d\n", analogValue, analogBits, lastDigit);
        
        wait_ms(DATATIME);
    }
}