#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"

//Code parameters

#define LCDLEN      10
//LCD messages
#define VOLTAST      0
#define VOLTMESS     "V:"
#define DATARATE    0.1 // sec
#define MAXVOLTS    3.3
#define FUTURESTATE 1

SLCD slcd; //define LCD display

//Global classes
TSISensor tsiScaling; // Capacitive sensor/slider
AnalogOut refOut(PTE30);
PwmOut led(LED_RED);

// Global scalars
char lcdData[LCDLEN];




void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 


    
void parameterAdjust( int adjState, float scaling) { // small adjustment state machine
    float  tempFloat;
    switch (adjState){
        case VOLTAST: {
             tempFloat = scaling;
             refOut.write(tempFloat);         
             sprintf (lcdData,"%4.3f",tempFloat*MAXVOLTS);         
             break;
        }
        case FUTURESTATE: {
             break;
        }
    }
    LCDMessNoDwell(lcdData);
    return;
}

int main(){
    
    float tempValue;
   
    parameterAdjust( VOLTAST, 0.0);
    
    
    while (true) {
        tempValue = tsiScaling.readPercentage();
        if(tempValue > 0) {
                    parameterAdjust( VOLTAST, tempValue);
        }  
        
       wait(DATARATE);
    } // while forever
}// end main