#include "mbed.h"
#include <iostream>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <locale.h> 
#include "rtos.h"
#include "SLCD.h"
// Debug printout control
#define PRINTDBUG
#define PROGNAME        "SerialIO v6\n\r"

#define LCDLEN          10
#define MAXCHAR         4
#define ALL8          "8888"
#define LCDUPDATE       100 //ms
#define LEDBLINKTIME    300 // ms *** NOTE Change of units ***
#define SERIALREADTIME  50 //ms
// ASCII constants
#define CR              '\r'
#define ALLNOTES        "CDEFGAB" // Note only 7 unique notes.
#define NUMTONES        10
#define NONOTE          8
#define NOTEOFFSET      1



float diatonicScale[NUMTONES] = {246.94, 261.63,293.66,329.63,349.23,392.00,440.00,493.88,523.25,587.33};

DigitalOut rLed(LED_RED);

 
Serial pc(USBTX, USBRX); // tx, rx
SLCD slcd; //define LCD display
char rxChar;
char rxString[LCDLEN];
string rxRealString;

void clearString (char * aString){
    int i;
    int sSize = sizeof(aString);
    
    for (i=0; i< sSize; i++){
        aString[i] = NULL;
    }
    return;
}
    
    
int isNote(char theNote){ //check for valid onte
    int noteListLen = sizeof(ALLNOTES);
    int pos = NONOTE;
    int i;
    for (i=0; i<noteListLen; i++){
        if (ALLNOTES[i] == theNote){
            pos = i;
            break;
        }
    }
    return (pos);
}


void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

// use "thread" in the name to keep things straight 
// note the use of void constant * args - understand memory resources
// Thes are "forever loops"
void LCDdis_thread(void const *args){
    while(true) {
        LCDMessNoDwell(rxString);
        Thread::wait(LCDUPDATE);
    }
}

void serial_thread(void const *args){
   static int charIndex =0;
   int rxStringLen;
   int noteOK;
   while(true) {
      if (pc.readable()) {                // only read from the serial port if there is a character
            rxChar= toupper(pc.getc());           // reading clears the buffer
            noteOK = isNote(rxChar);
            // construct a 4-digit string for the LCD          
            // check for carriage return           
            if (rxChar == CR) { 
                rxRealString.assign(rxString);                                                                
                rxStringLen = rxRealString.length();  
#ifdef PRINTDBUG    
                pc.printf("%s - StringLen = %d OK \n\r", rxString, rxStringLen);
#endif  
                charIndex = 0; // start building string from position zero next time around
            } else {
                if(charIndex == 0) clearString(rxString);
                rxString[charIndex] = rxChar;
                rxRealString.assign(rxString);
#ifdef PRINTDBUG
                if(noteOK != NONOTE){
                    pc.printf("%s - IsNote - %4.2f\n\r", rxString, diatonicScale[noteOK + NOTEOFFSET]); 
                } else {
                    pc.printf("%s - Not a Note\n\r", rxString);
                }  
#endif                  
                charIndex = (charIndex + 1)% (MAXCHAR); // Only allow 4 characters then roll over
               
            }
      }
      Thread::wait(SERIALREADTIME);
    }
}

int main()
{  
 
    Thread lthread(LCDdis_thread);
    Thread serthread(serial_thread);
    
    sprintf(rxString,"%s",ALL8);  // just put something on the LCD to show it's working
    
#ifdef PRINTDBUG
        pc.printf(PROGNAME);
#endif

    while (true) {     
        rLed = !rLed; // toggle led
        Thread::wait(LEDBLINKTIME);
    }
}