#include "mbed.h"
#include "rtos.h"
#include "SLCD.h"

#define LCDLEN          10
#define MAXCHAR         4
#define ALL8          "8888"
#define LCDUPDATE       100 //ms
#define LEDBLINKTIME    300 // ms *** NOTE Change of units ***
#define SERIALREADTIME  50 //mw


DigitalOut rLed(LED_RED);

 
Serial pc(USBTX, USBRX); // tx, rx
SLCD slcd; //define LCD display
char rxChar;
char rxString[LCDLEN];

void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

// use "thread" in the name to keep things straight 
// note the use of void constant * args - understand memory resources
// Thes are "forever loops"
void LCDdis_thread(void const *args){
    while(true) {
        LCDMessNoDwell(rxString);
        Thread::wait(LCDUPDATE);
    }
}

void serial_thread(void const *args){
   static int charIndex = 0;
   while(true) {
      if (pc.readable()) {                // only read from the serial port if there is a character
            rxChar= pc.getc();              // reading clears the buffer
            rxString[charIndex] = rxChar;   // construct a 4-digit string for the LCD
            pc.printf("%s\n\r", rxString); 
            charIndex = (charIndex + 1 )% MAXCHAR; // Only allow 4 characters then roll over
      }
      Thread::wait(SERIALREADTIME);
    }
}

int main()
{  
 
    Thread lthread(LCDdis_thread);
    Thread serthread(serial_thread);
    
    sprintf(rxString,"%s",ALL8);  // just put something on the LCD to show it's working

    while (true) {     
        rLed = !rLed; // toggle led
        Thread::wait(LEDBLINKTIME);
    }
}