#include "mbed.h"
#include "SLCD.h"

#define LCDLEN      10
#define MAXCHAR     4
#define LEDBLINKTIME 0.2f


DigitalOut rLed(LED_RED);

 
Serial pc(USBTX, USBRX); // tx, rx
SLCD slcd; //define LCD display
char rxChar;
int charIndex = 0;
char rxString[LCDLEN];
bool charReady = false;

// set up intterupt for serial port

void serialISR(){
  rxChar = pc.getc();   // reading clears the buffer
  pc.printf("%c\n\r", rxChar);
  rxString[charIndex] = rxChar;
  charIndex = (charIndex + 1 )% MAXCHAR;
  charReady = true;
  return;
}

void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}


int main()
{  
 // set up interrupt   
    pc.attach(&serialISR);
    
    while (true) {     
        rLed = !rLed; // toggle led
        if (charReady) {
            LCDMessNoDwell(rxString);
            charReady = false;
        }
        wait(LEDBLINKTIME);
    }
}