#include "mbed.h"
#include "SLCD.h"

#define LCDLEN          10
#define MAXCHAR         4
#define LCD_UPDATE_TIME 100 // in ms
#define LEDBLINKTIME     0.2f
#define ALL8            "8888"


DigitalOut rLed(LED_RED);

 
Serial pc(USBTX, USBRX); // tx, rx
SLCD slcd; //define LCD display
char rxChar;
int charIndex = 0;
char rxString[LCDLEN];

void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}


int main()
{  
    LCDMessNoDwell(ALL8); // just put something on the LCD to show it's working
    
    while (true) {     
        rLed = !rLed; // toggle led
        if (pc.readable()) {                // only read from the serial port if there is a character
            rxChar= pc.getc();              // reading clears the buffer
            pc.printf("%c\n\r", rxChar);    // echo that character
            rxString[charIndex] = rxChar;   // construct a 4-digi string for the LCD
            charIndex = (charIndex + 1 )% MAXCHAR; // Only allow 4 characters the roll over
            LCDMessNoDwell(rxString);       // display it
        }
        wait(LEDBLINKTIME);
    }
}