#include "mbed.h"
#include "MMA8451Q8b.h"
#include "SLCD.h"
/* 
Test of the accelerometer, digital I/O, on-board LCD screen, and 16-bit ADC.
 Looing at vector product of the x-y components of the accelerometer.
 Works pretty well. Still rough, program wise - sc 140710
 Addiing touch sensor to replace potentiometer.
 Show x and y components 
 */
/*
* Update getGLimit to map to application note AN4076
*http://cache.freescale.com/files/sensors/doc/app_note/AN4076.pdf
*/
#define BLINKTIME 0.7
#define DATATIME 0.1
#define DATADISPDWELL 0.2
#define NUMLEDS 2
#define LEDON 0
#define LEDOFF 1
#define SCALING 13
#define LCDLEN 10
#define RSTARTMESS "PNCH"
#define MAXVECT "MAXV"
#define XCOMP "XCMP"
#define YCOMP "YCMP"
#define ZCOMP "ZCMP"
#define ANALTOVOLTS 3.3
#define LEDDELAY 0.400
//define states
#define NUMSTATES 4
#define XCOMPD 0
#define YCOMPD 1
#define ZCOMPD 2
#define VMAXD 3
#define MAXGS 8
#define COUNTSCALE 1
#define REG_WHO_AM_I      0x0D
#define XYZ_DATA_CFG      0x0E

#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05

#define MAX_2G            0x00
#define MAX_4G            0x01
#define MAX_8G            0x02


#define PROGNAME "LCD_punch_mtr 8 v6\r\n"
#define LCDNAME "PC.V6"


//#define PRINTDBUG
// Accelerometer SPI pins
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

SLCD slcd; //define LCD display
Timer blinkTimer;
Timer dataTimer;
Timer displayTimer;
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
AnalogIn TMP01(PTB1);
DigitalOut LEDs[NUMLEDS]={LED_RED, LED_GREEN}; //Indicator LEDs
Serial pc(USBTX, USBRX);
char displayTitles[NUMSTATES][LCDLEN] = {XCOMP,YCOMP,ZCOMP,MAXVECT};
float accaxisdata[NUMSTATES];
char displayformats[NUMSTATES][LCDLEN] = {"x.%3.2f","y.%3.2f","z.%3.2f","v.%3.2f"};
//char displayformats[NUMSTATES][LCDLEN] = {"%4.3f","%4.3f","%4.3f","%4.3f"};
char lcdData[LCDLEN]; //buffer needs places dor decimal pt and colon

void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void LCDsignedFloat(float theNumber){
    sprintf (lcdData," %3.2f",theNumber); 
    // changed SLCD.cpp to interpret < as -
    if (theNumber < 0.0) sprintf (lcdData,"<%3.2f",fabs(theNumber));   
    LCDMessNoDwell(lcdData); 
}
void allLEDsOFF(int numberOfLEDS) {
    int i;
    for (i=0;i<numberOfLEDS; i++){
            LEDs[i] = LEDOFF;
        }

}

void runLEDs(int numberOfLEDS) {
    int i;
    for (i=0;i<numberOfLEDS; i++){
            LEDs[i] = LEDON;
            wait(0.2);
        }
   allLEDsOFF(numberOfLEDS);     
}



int main() {
    
    int RButtonState;
    int LButtonState;
    DigitalIn RtButton(PTC12);
    DigitalIn LftButton(PTC3);
    int displayState = XCOMPD; 
    float xAcc = 0.0;
    float yAcc = 0.0;
    float zAcc = 0.0;
    float vector;
    float vMax = 0.0;
    float DisplayTime = DATADISPDWELL;
    float LEDDwell = BLINKTIME;
    int outState = false;
    
    uint8_t regData = MAX_2G; // test value must change after G setting
    uint16_t xCounts;

    
#ifdef PRINTDBUG
        pc.printf(PROGNAME);
#endif
    LCDMess(LCDNAME, BLINKTIME);
// Initialze readings and sequence the LED's for dramtic effect.
    allLEDsOFF(NUMLEDS);
    blinkTimer.start();
    blinkTimer.reset();
    displayTimer.start();
    displayTimer.reset();
    dataTimer.start();
    dataTimer.reset();
    LCDMess(RSTARTMESS, BLINKTIME);
// Go into registers ofn Accelerometer, change sensitivity then test.
// http://cache.freescale.com/files/sensors/doc/data_sheet/MMA8451Q.pdf
// See page 26
// Set  8g max limit ****************** Note limits
    acc.setGLimit(MAX_8G); // For now set to 2g
    acc.readRegs(XYZ_DATA_CFG, &regData, 1);
    sprintf (lcdData,"GS %d",regData);
    LCDMess(lcdData,BLINKTIME);
    acc.readRegs(REG_WHO_AM_I, &regData, 1);
    sprintf (lcdData,"AM %d",regData);
    LCDMess(lcdData,BLINKTIME);   
// main loop forever 
    while(true) {

// Handle user input for display selections
        RButtonState = !RtButton; // button is pulled up so false is when button is pushed it's inverted to avoid confusion downstream
        if (RButtonState){
            vMax = 0.0; // Clear vMax
            LCDMess(RSTARTMESS, BLINKTIME);
        }
        LButtonState = !LftButton;
        if (LButtonState) {  //Change data that is displayed
            displayState = (displayState + 1) % NUMSTATES;
            // Change to switch/case soon.
            LCDMess(displayTitles[displayState],BLINKTIME);     
        }
        
// --------------------------------------------
        while (dataTimer.read() > DATATIME){

// No offset
            xAcc = acc.getAccX();
            xCounts = acc.getAccAxis(REG_OUT_X_MSB);
            yAcc = acc.getAccY();
            zAcc = acc.getAccZ();
 // Calulate vector sum of x,y and z reading.       
            vector = sqrt(pow(xAcc,2) + pow(zAcc,2));
            vector = zAcc;
            if (vector > vMax) {
                vMax = vector;
            }
//Prepare data for LCD display 
            accaxisdata[XCOMPD] = xAcc; // scalling is set to 1 at this point
            accaxisdata[YCOMPD] = yAcc;
            accaxisdata[ZCOMPD] = zAcc;
            accaxisdata[VMAXD] = vMax;
            dataTimer.reset();
            LEDDwell = 1.1 - vMax/MAXGS;
        }

// Display the appropriate data on the LCD based upon what mode was chosen
        while (displayTimer.read() > DisplayTime){
            LCDsignedFloat(accaxisdata[displayState]);
            /*
            sprintf (lcdData,displayformats[displayState],accaxisdata[displayState]);          
            LCDMessNoDwell(lcdData);
            */
            displayTimer.reset();
        } // displaytimer 
// Wait then do the whole thing again.  
// Alive LEDs
        while(blinkTimer.read()> LEDDwell) {     
            LEDs[0].write(outState);
            LEDs[1].write(!outState);
            outState = !outState; 
            blinkTimer.reset();
        } 
    }//forever loop
}// main