#include "mbed.h"

#include "SLCD.h"
#define RELAYON 0
#define RELAYOFF 1
#define LEDDELAY 0.75
#define WAITDELAY 3.0
 
Ticker ledBlink; // timinginterrupt for RED led
InterruptIn mybutton(PTC3);  //push botton with internal pullup
DigitalOut myled(LED_RED); // red led
DigitalOut relay(LED_GREEN); // green led

 
float delay = WAITDELAY;
int relayState = RELAYOFF;
int outState = false;
SLCD slcd; //define LCD display
char LCDMessages[2][10] = {"TRUE", "FALS"};


void LCDMess(char *lMess){
        slcd.Home();// message stays till next update
        slcd.clear();
        slcd.printf(lMess);
}

void LEDBlinker(){  // RED LED interrupt
    outState = !outState; 
    myled.write(outState);
}
        
    
void pressed() // button intterupt
{
    relayState = !relayState;
    relay.write(relayState);
}

int main()
{
    myled.write(outState);
    relay.write(relayState);
    mybutton.fall(&pressed);
    ledBlink.attach(&LEDBlinker, LEDDELAY);
    while (true) { 
    // other things can be put here.  
        LCDMess(LCDMessages[relayState]);  
        wait(delay);
    }
}
