#include "mbed.h"
#include "SLCD.h"
 
#define PROGNAME "kl46z_LCD v1\n\r"
#define LEDON false
#define LEDOFF true
#define LCDCHARLEN 10
#define HELLO_LCD "HLLO"
 
// slightly more interesting blinky 140814 sc
SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

float blinks[]={0.400, 0.700};
int ledState = LEDON;
DigitalOut greenColor(LED_GREEN);
DigitalOut redColor(LED_RED);

 
void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}
//--------------------------------
int main() {
    pc.printf(PROGNAME);
    
    while(true) {
        ledState = !ledState; // Flip the general state
        redColor = ledState;
        greenColor = !ledState;// flip state but don't store it.
        redColor.write(ledState);
        greenColor.write(!ledState);// flip state but don't store it.
        if(ledState){
            LCDMess(HELLO_LCD);
        } else {
            slcd.clear();
        }
        wait(blinks[ledState]);
    }
}
