#include "mbed.h"
#include "SLCD.h"

//Dating Game Capkey controller 07/16/2013 sc
// Modified for mbet KL46Z 10/07/2014
// Four inputs and Four relays
// Changed to simulate capkeys with the KL on board buttons
#define PROGNAME "DG Cap Key v2.1\r\n"
#define KEYHIT "SND"
#define IDLEMESS "IDLE"
#define HIGH 1
#define LOW 0
#define RESET_DELAY 1200
#define RELAY_ON HIGH
#define RELAY_OFF LOW
#define LED_ON LOW
#define LED_OFF HIGH
#define DEBOUNCE 50
#define NUMREL 6 // really just the number of outputs
#define LCDDELAY 0.200
#define COUNTERLIMIT 300
#define TESTCHANNEL 0
#define LEDDELAY 0.75
#define CHNLLCDPRINT "CH-%1d"
#define RASPIOUTDBG "PIOUT = %d \n\r"

DigitalOut Relays[NUMREL] = {D10,D11,D12,D13,PTC13,PTC16}; // corresponds to touches 1,2,3,4
DigitalIn capKeys[NUMREL] = {D2,D4,D6,D8,PTC6,PTC7};
DigitalOut capRST[NUMREL] = {D3,D5,D7,D9,PTC10,PTC11};
//DigitalIn sendKey(PTC3); // on board buttons just use 1 for test
DigitalOut REDLed(LED_RED); // red led
DigitalOut GREENLed(PTD5); // green led



Ticker ledBlink; // timinginterrupt for RED led
Timer millis;
Serial pc(USBTX, USBRX);
SLCD slcd; //define LCD display
//InterruptIn chanButton(PTC12);
int channelSelect=0;
int channelDisplay = 1;

// variables will change:
int buttonState = true;
long relayTimeout;
long capKeyTimeout;
int LCDCounter = 0;
int outState = false;

void LEDBlinker(){  // RED LED interrupt
    outState = !outState; 
    REDLed.write(outState);
    GREENLed.write(!outState);
}

void getChannel() { // button interrupt
    channelSelect = (channelSelect + 1) % NUMREL;
    channelDisplay = channelSelect +1;
}
    
void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
// variable for reading the pushbutton status

int main() {
  int i;
  int buttonVal = 0;

  char lcdData[10]; //buffer needs places for decimal pt and colon
  int OKtoRead = true;
  
  ledBlink.attach(&LEDBlinker, LEDDELAY);// Alive LED
  millis.start();
  millis.reset();
  
  pc.printf(PROGNAME);
  sprintf (lcdData,IDLEMESS); //Show that things are on
  LCDMess(lcdData, LCDDELAY);  
  for (i=0; i<NUMREL; i++){ 
          Relays[i].write(RELAY_OFF);
          capRST[i].write(HIGH);
          capKeys[i].mode(PullDown); // click out the pull-up resistor looks like it needs a pulldown
  }  

 while (true) {
   // Show active channel
   
   
   
  // read the state of the pushbutton value:
  if(OKtoRead) {
    for (i=TESTCHANNEL; i<NUMREL; i++){
        if (capKeys[i] == HIGH) {
            channelSelect = i;
            channelDisplay = channelSelect +1;
            buttonVal = true; // Got a touch
            break;
        }
    }
    //buttonVal = !sendKey.read() ; // on board buttons just use 1
    if (buttonVal){    
        Relays[channelSelect].write(RELAY_ON);    
        capRST[channelSelect].write(LOW); //reset the cap key
        pc.printf(RASPIOUTDBG, channelSelect);
        millis.reset();
        relayTimeout = RESET_DELAY;
        OKtoRead = false;
        buttonVal = false;
        sprintf (lcdData,CHNLLCDPRINT,channelDisplay);
        LCDMess(lcdData, LCDDELAY);
    
      }
    }//end OKtoRead

    if (millis.read_ms() > relayTimeout) {
      OKtoRead = true;
      sprintf (lcdData,IDLEMESS);
      LCDMess(IDLEMESS, LCDDELAY);
      for (i=0; i<NUMREL; i++){ 
         Relays[i].write(RELAY_OFF);
         capRST[i].write(HIGH);     
       }  
     }

   }// end forever while
} // end main