#include "mbed.h"
#include "SLCD.h"

//Dating Game Capkey controller 07/16/2013 sc
// Modified for mbet KL46Z 10/07/2014
// Four inputs and Four relays
// Changed to simulate capkeys with the KL on board buttons
#define PROGNAME "DG Cap Key v1.1\r\n"
#define KEYHIT "SND"
#define SERIAL_SPEED 9600
#define HIGH 1
#define LOW 0
#define RESET_DELAY 1200
#define RELAY_ON HIGH
#define RELAY_OFF LOW
#define LED_ON LOW
#define LED_OFF HIGH
#define DEBOUNCE 50
#define NUMREL 4 // really just the number of outputs
#define LCDDELAY 0.200
#define COUNTERLIMIT 300


DigitalOut Relays[NUMREL] = {D10,D11,D12,D13}; // corresponds to touches 1,2,3,4
//DigitalIn capKeys[NUMREL] = {D2,D4,D6,D8};
DigitalOut capRST[NUMREL] = {D3,D5,D7,D9};
DigitalIn sendKey(PTC3); // on board buttons just use 1 for test




Timer millis;
Serial pc(USBTX, USBRX);
SLCD slcd; //define LCD display
InterruptIn chanButton(PTC12);
int channelSelect=0;
int channelDisplay = 1;

// variables will change:
int buttonState = true;
long relayTimeout;
long capKeyTimeout;
int LCDCounter = 0;

void getChannel() { // button interrupt
    channelSelect = (channelSelect + 1) % NUMREL;
    channelDisplay = channelSelect +1;
}
    
void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
// variable for reading the pushbutton status

int main() {
  int i;
  int buttonVal = 0;

  char lcdData[10]; //buffer needs places dor decimal pt and colon

  int OKtoRead = true;
  
  chanButton.fall(&getChannel);
  
  // initialize the LED pin as an output:  
  millis.start();
  millis.reset();
  
  pc.printf(PROGNAME);  
  for (i=0; i<NUMREL; i++){ 
          Relays[i].write(RELAY_OFF);
          capRST[i].write(HIGH);
  }  

 while (true) {
   // Show active channel
   
   sprintf (lcdData,"CH-%1d",channelDisplay);
   LCDMess(lcdData, LCDDELAY);
   
  // read the state of the pushbutton value:
  if(OKtoRead) {
    buttonVal = !sendKey.read() ; // on board buttons just use 1
    if (buttonVal){    
        sprintf (lcdData,"SND%1d",channelDisplay);
        LCDMess(lcdData, LCDDELAY);
        Relays[channelSelect].write(RELAY_ON);    
        capRST[channelSelect].write(LOW); //reset the cap key
        pc.printf("Relay = %d \n\r", channelSelect);
        millis.reset();
        relayTimeout = RESET_DELAY;
        OKtoRead = false;
    
      }
    }//end OKtoRead

    if (millis.read_ms() > relayTimeout) {
      OKtoRead = true;
      for (i=0; i<NUMREL; i++){ 
         Relays[i].write(RELAY_OFF);
         capRST[i].write(HIGH);     
       }  
     }

   }// end forever while
} // end main