#include "mbed.h"
#include "SLCD.h"

//Dating Game Capkey controller 07/16/2013 sc
// Modified for mbet KL46Z 10/07/2014
// Four inputs and Four relays
// Changed to simulate capkeys with the KL on board buttons
#define PROGNAME "DG Cap Key v1.1\r\n"
#define KEYHIT "KEY1"
#define SERIAL_SPEED 9600
#define HIGH 1
#define LOW 0
#define RESET_DELAY 1200
#define RELAY_ON HIGH
#define RELAY_OFF LOW
#define LED_ON LOW
#define LED_OFF HIGH
#define DEBOUNCE 50
#define NUMREL 2 // really just the number of outputs
#define LCDDELAY 0.200
#define COUNTERLIMIT 300

// constants won't change. They're used here to 



/*
DigitalOut Relays[NUMREL] = {D10,D11,D12,D13}; // corresponds to touches 1,2,3,4
DigitalIn capKeys[NUMREL] = {PTC3,D4,D6,D8};
DigitalOut capRST[NUMREL] = {D3,D5,D7,D9};
*/
// make two channel both buttons for testing
DigitalOut Relays[NUMREL] = {D10,D11}; 
DigitalIn capKeys[NUMREL] = {PTC3, PTC12}; // on board buttons
DigitalOut capRST[NUMREL] = {D3,D5};
DigitalOut LEDs[NUMREL] = {LED_GREEN, LED_RED};
/*
DigitalOut RLed(LED_RED);
DigitalOut GLed(LED_GREEN);
*/
Timer millis;
Serial pc(USBTX, USBRX);
SLCD slcd; //define LCD display

// variables will change:
int buttonState = true;
long relayTimeout;
long capKeyTimeout;
int LCDCounter = 0;

void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
// variable for reading the pushbutton status

int main() {
  int i;
  int buttonVal = 0;
  int buttonVal2 = 0;
  int ledState = LED_ON;
  char lcdData[10]; //buffer needs places dor decimal pt and colon

  int OKtoRead = true;
  // initialize the LED pin as an output:  
  millis.start();
  millis.reset();
  
  pc.printf(PROGNAME);  
  for (i=0; i<NUMREL; i++){ 
          Relays[i].write(RELAY_OFF);
          capRST[i].write(HIGH);
          LEDs[i].write(LED_OFF);
  }  

 while (true) {
   // For dramatic effect
   ledState = !ledState;
   LCDCounter++;
   LCDCounter = LCDCounter % COUNTERLIMIT;
   sprintf (lcdData,"%3d",LCDCounter);
   LCDMess(lcdData, LCDDELAY);
   //RLed.write(ledState);
   //GLed.write(ledState);
   //End dramatic effect
   
   
  // read the state of the pushbutton value:
  if(OKtoRead) {
    for (i=0; i<NUMREL;i++){
      buttonVal = ! capKeys[i].read();
      wait_ms(DEBOUNCE);
       buttonVal2 = ! capKeys[i].read();
       buttonVal = buttonVal && buttonVal2;
        if (buttonVal){    
          LCDMess(KEYHIT, LCDDELAY);
          Relays[i].write(RELAY_ON);    
          capRST[i].write(LOW); //reset the cap key
          LEDs[i].write(LED_ON);
          pc.printf("Relay = %d \n\r", i);
          millis.reset();
          relayTimeout = RESET_DELAY;
          OKtoRead = false;
          break;
        }
      }
    }//end OKtoRead

    if (millis.read_ms() > relayTimeout) {
      OKtoRead = true;
      for (i=0; i<NUMREL; i++){ 
         Relays[i].write(RELAY_OFF);
         capRST[i].write(HIGH); 
         LEDs[i].write(LED_OFF);       
       }  
     }

   }// end forever while
} // end main