#include "mbed.h"
/* Set up as stete machine with case/switch formulation
*/
// Stated 
#define IDLE 0
#define PULSE 1
#define READ 2

//#define PRINTDBUG

#define WAITTIME 50 // ms -for time between data takes 
#define CONVERTTIME 50 // ms - for tiee for Maxbotix to convert range measurement
#define NEARLIMIT 0.025
#define FARLIMIT 0.40
#define LEDON 1
#define LEDOFF 0
#define LEDFULLBRITE 0.0
#define LEDNOBRITE 1.0
#define HALFBRITE 0.5
#define PULSE_ON 1 
#define PULSE_OFF 0
#define RXWIDTH 100 // uSec
#define RESETPULSE 100 // ms
#define RESETTIME 20000 // ms
#define MAXBOOTTIME 500 // mw
#define PROGNAME "AnalogMAX v\r\n"  // puTTY does not automatically add carriage return

AnalogIn input(PTC2);
DigitalOut Relay(PTE29);
DigitalOut RXRead(PTE23);
DigitalOut PWRReset(PTE22);

// Set up PWM on all three colors
PwmOut greenLED(LED_GREEN); // green led
PwmOut blueLED(LED_BLUE);
PwmOut redLED(LED_RED); // red led
Serial pc(USBTX, USBRX);
Timer millis;
Timer resetTimer;

int ledState = false;

void RevPulseOut_ms(DigitalOut outport, int pulseWidth) {
    outport = PULSE_ON;
    outport = PULSE_OFF;
    wait_ms(pulseWidth);
    outport = PULSE_ON;
    return;
}
// --------------
void pulseOut(DigitalOut outport, int pulseWidth) {
    outport = PULSE_OFF;
    outport = PULSE_ON;
    wait_us(pulseWidth);
    outport = PULSE_OFF;
    return;
}
// ---------------
void takeData(float spanScale) {
            
    float samples;
    float scaledPWM;
    
        
        samples = input.read();
#ifdef PRINTDBUG
        pc.printf("%f\r\n", samples);
#endif
    if ((samples > NEARLIMIT) && (samples < FARLIMIT)){
            scaledPWM = (samples - NEARLIMIT)*spanScale;
            redLED = 1.0 - scaledPWM;
            blueLED = scaledPWM;
            Relay = LEDON;
#ifdef PRINTDBUG
            pc.printf("RED -> %f BLUE -> %f\r\n", redLED.read(), blueLED.read());
#endif
    }else{
            redLED = LEDNOBRITE; // off
            blueLED = LEDNOBRITE;
            Relay = LEDOFF;
    }
    return;
}
// end takeData()
// ----------------------------
int main() {
    int currentState = IDLE;
    int stateTime = WAITTIME;
    float spanScale; // compute scale to expand to full range of PWM duty factors

  // initialization  
  // calulate scaling for red/blue LED
   
    RXRead = PULSE_OFF;
    PWRReset = PULSE_ON;
    spanScale = 1.0/(FARLIMIT-NEARLIMIT);
    pc.printf(PROGNAME);
    
    greenLED = HALFBRITE; // 1/2 on
    redLED = LEDNOBRITE; // pwm off
    blueLED = LEDFULLBRITE; // pwm on
    RevPulseOut_ms(PWRReset, RESETPULSE);
    millis.start();
    resetTimer.start();
    millis.reset();
    resetTimer.reset();
     // Bring Maxbotix RX line to 0 volts
// Loop forever
    while(true){ 
    
        switch (currentState) {
            case IDLE: {
                    if (millis.read_ms() > stateTime) { // WAITTIME
                        currentState = PULSE;                      
                    }
                    break;
                }
            case PULSE: {
                    pulseOut(RXRead, RXWIDTH);
                    millis.reset(); //reset timer to 0 for wait for convert time;
                    stateTime = CONVERTTIME;
                    currentState = READ;
                    break;
                }
            case READ: {
                     if (millis.read_ms() > stateTime) { // PULSETIME
                        takeData(spanScale);
                        currentState = IDLE;   
                        stateTime = WAITTIME; 
                        millis.reset();                     
                    }
                    break;
                    }
            }   
/* Does not work yet */
         if(resetTimer.read_ms() > RESETTIME){  // recalibrate the Maxbotix
            RevPulseOut_ms(PWRReset, RESETPULSE);
            wait_ms(MAXBOOTTIME);
            resetTimer.reset();
        } 
 /* --------------- */
    }  
}   // end main