#include "mbed.h"

//#define PRINTDBUG
#define WAITTIME 100
#define NEARLIMIT 0.025
#define FARLIMIT 0.40
#define LEDON false
#define LEDOFF true
#define LEDFULLBRITE 0.0
#define LEDNOBRITE 1.0
#define HALFBRITE 0.5
#define PROGNAME "AnalogMAX v2\r\n"  // puTTY does not automatically add carriage return

AnalogIn input(PTC2);
// Set up PWM on all three colors
PwmOut greenLED(LED_GREEN); // green led
PwmOut blueLED(LED_BLUE);
PwmOut redLED(LED_RED); // red led
Serial pc(USBTX, USBRX);
Timer millis;

int ledState = false;

void takeData(float spanScale) {
            
    float samples;
    float scaledPWM;
    
        samples = input.read();
#ifdef PRINTDBUG
        pc.printf("%f\r\n", samples);
#endif
    if ((samples > NEARLIMIT) && (samples < FARLIMIT)){
            scaledPWM = (samples - NEARLIMIT)*spanScale;
            redLED = 1.0 - scaledPWM;
           // greenLED = LEDOFF; // on
            blueLED = scaledPWM;
#ifdef PRINTDBUG
            pc.printf("RED -> %f BLUE -> %f\r\n", redLED.read(), blueLED.read());
#endif
    }else{
            redLED = LEDNOBRITE; // off
            // greenLED = HALFBRITE;
            blueLED = LEDNOBRITE;
    }
    return;
}
// end takeData()
// ----------------------------
int main() {
    float spanScale;

  // initialization  
  // calulate scaling for red/blue LED
   
    
    spanScale = 1.0/(FARLIMIT-NEARLIMIT);
    pc.printf(PROGNAME);
    
    greenLED = HALFBRITE; // 1/2 on
    redLED = LEDNOBRITE; // pwm off
    blueLED = LEDFULLBRITE; // pwm on
    millis.start();
    millis.reset();
// Loop forever
    while(true){     
        if (millis.read_ms() > WAITTIME) { 
            takeData(spanScale);
            millis.reset();
        }
    }      
   
}   // end main