#include "mbed.h"
#include "SLCD.h"

// copied from Change state example for basis 02.22.2014 sc
#define PROGNAME "555_onshot trigger v3\r\n"
#define HIGH 1
#define LOW 0
#define PIN_2_555 D2
#define PIN_3_555 D3
#define PIN_3_CLONE LED_GREEN
#define LEDON LOW
#define LEDOFF HIGH
#define OUTPULSELEN 100 // ms
#define DATADELAY 1
#define SERIALSPEED 57600
#define MAX_OUT 1500 // ms
#define MIN_OUT 500
#define ABORTTIME 3500
#define INPUTSTART 1
#define DATARATE 1000 // ms time between data takes.
#define LCDLEN 10
#define STARTMESS "STRT"
#define BGNMESS "BEGN"

// this constant won't change:
DigitalOut oneShotIn (PIN_2_555); 
// the pin that the pushbutton is attached to
DigitalIn oneShotOut (PIN_3_555);
DigitalOut ledPin(PIN_3_CLONE);       // the pin that the LED is attached to
Serial pc(USBTX, USBRX);
SLCD slcd; 
Timer milliTimer; 

long  oneShotLen;
long timeOut = ABORTTIME;
long nextDataTake = DATARATE;
long oneShotBegin;
long oneShotEnd;
// Variables will change:
int buttonPushCounter = 0;   // counter for the number of button presses
int buttonState = 0;         // current state of the button
int lastButtonState = 0;     // previous state of the button


void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 
void pulseOut (long pulseLen){
    oneShotIn.write(LOW);
    wait_us(pulseLen);
    oneShotIn.write(HIGH);
}

void setup() {
  
  // initialize serial communication:
  
  pc.printf(PROGNAME);
  LCDMess(BGNMESS);
  oneShotIn.write(HIGH);
  oneShotOut.mode(PullNone);
  ledPin.write(LOW);
  milliTimer.start();
  milliTimer.reset();
  nextDataTake =  DATARATE;
  lastButtonState = LOW;
}


void loop() {
  char lcdData[LCDLEN];
  oneShotLen = 0;
  if (milliTimer.read_ms() > nextDataTake){
     LCDMess(STARTMESS);
     pulseOut(OUTPULSELEN); 
     wait_ms(DATADELAY);
     buttonState = oneShotOut.read();
     if (buttonState == INPUTSTART) {
        oneShotBegin = milliTimer.read_ms();
        ledPin.write(LEDON);
        while ((buttonState == INPUTSTART) && (oneShotLen < ABORTTIME)){
          oneShotLen = milliTimer.read_ms();
          //pc.printf("%d\r\n",oneShotLen);  
          buttonState = oneShotOut.read();      
       } 
       pc.printf("%d\r\n",oneShotLen);  
       sprintf(lcdData,"%4d",oneShotLen);
       LCDMess(lcdData);
       ledPin.write(LEDOFF);
       milliTimer.reset();
       nextDataTake = DATARATE;
    } 
   
  }
 
}

int main(){
    setup();
    while (true) {
        loop();
    }
}