// acquerir la temperature avec le LM75B
// acquerir consigne avec Pot1
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LM75B.h"
#include "acquisition.h"
#include "affichagesp3.h"
#include "wifiesp8266.h"
#include "bouton.h"
#include <stdlib.h>

float VitFluxAir = 0;
float ConsigneFluxAir = 0;
float Freqhelice = 0;
float Temperature = 0;
float humidite = 0;
float pression[8] = {0,0,0,0,0,0,0,0};
float Fx = 0;
float Fz = 0;
float Aim = 0;
float Aic = 0;

RawSerial PC(USBTX, USBRX);
WifiEsp8266 Wifi(PA_11,PA_12,1.0); // WifiEsp8266(PinName Txd, PinName Rxd,float _timeout);
DigitalOut En(PC_11);

int main()
{
    float mesure, mesure1;
    float AngleIncCons;
    En.write(1);
    bool ecranchange=false;
    char WifiPhrase[maxdata];
    PC.baud(921600);
    PC.printf("Hello SP3\r\n");
    AffichageEcransp3();
    InitBouton();
    char bouton;
    while (true) {
        bouton = EtatBouton();
        if (bouton!=Nochange) {
            Wifi.printf("$%c\n\r",bouton);        
        }
        if (Wifi.dataready()) {
            strcpy(WifiPhrase,Wifi.read());
            PC.printf("%s\r\n",WifiPhrase);
            switch (WifiPhrase[1]) {
                 case 'A':
                    VitFluxAir = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;               
                 case 'B':
                    ConsigneFluxAir = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;                  
                 case 'C':
                    Freqhelice = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;                   
                 case 'D':
                    Temperature = atof(WifiPhrase+2);
                    ecranchange=true;
                    break; 
                 case 'E':
                    humidite = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;                     
                case 'Z':
                   if (sscanf(WifiPhrase,"$Z,%f,%f,%f",&VitFluxAir,&Temperature,&humidite)>=1) ecranchange=true;
                    break;                                                          
                case 'a':
                    pression[0] = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;  
                case 'b':
                    pression[1] = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;                     
                 case 'c':
                    pression[2] = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;                    
                 case 'd':
                    pression[3] = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;   
                case 'e':
                    pression[4] = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;                                      
                case 'f':
                    pression[5] = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;                     
                case 'g':
                    pression[6] = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;                     
                case 'h':
                    pression[7] = atof(WifiPhrase+2);
                    ecranchange=true;
                    break; 
                case 'i':
                    Fx = atof(WifiPhrase+2);
                    ecranchange=true;
                    break; 
                case 'j':
                    Fz = atof(WifiPhrase+2);
                    ecranchange=true;
                    break; 
                case 'k':
                    Aim = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;                                           
                case 'l':
                    Aic = atof(WifiPhrase+2);
                    ecranchange=true;
                    break;
                case 'z':
                   if (sscanf(WifiPhrase,"$z,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f",pression,pression+1,pression+2,pression+3,pression+4,pression+5,pression+6,pression+7,&Fx,&Fz,&Aim)>=1) ecranchange=true;
                    break;                                                          
                default : ;
            }
        }
        if (ecranchange) {
            AffichageEcransp3();
            ecranchange=false;
        }
    }
}

