// acquerir la temperature avec le LM75B
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LM75B.h"
#include "acquisition.h"
#include "affichagesp2.h"
#include "wifiesp8266.h"

float VitFluxAir = 0;
float pression[8] = {0,0,0,0,0,0,0,0};
float Fx = 0;
float Fz = 0;
float Aim = 0;
float Aic = 0;

RawSerial PC(USBTX, USBRX);
WifiEsp8266 Wifi(PA_11,PA_12); // WifiEsp8266(PinName Txd, PinName Rxd,float _timeout);
DigitalOut En(PC_11);
LM75B sensor(D14,D15);

Ticker test1;
bool Drticker1 = false;
void event1()
{
    Drticker1 = true;
}

int main()
{
    En.write(1);
    char WifiPhrase[maxdata];
    bool ecranchange=false;
    AnalogIn Pot1(A0);
    AnalogIn Pot2(A1);
    AffichageEcransp2();
    PC.baud(921600);
    PC.printf("Hello je suis SP2\r\n");
    test1.attach(&event1,1);
    while (true) {
        if (Wifi.dataready()) {
            strcpy(WifiPhrase,Wifi.read());
            // PC.printf("%s\r\n",WifiPhrase);
            switch (WifiPhrase[1]) {
                case 'A':
                    VitFluxAir= atof(WifiPhrase+2);
                    ecranchange=true;
                    break;
                case 'm':
                    Aic=Aic+1;
                    Wifi.printf("$l%0.0f\r\n",Aic);
                    ecranchange=true;
                    break;
                case 'n' :
                    Aic=Aic-1;
                    Wifi.printf("$l%0.0f\r\n",Aic);
                    ecranchange=true;
                    break;
                default :
                    ;
            }

        }

        if (Drticker1) {
            Drticker1 = false;
            pression[0] = Pot2.read()*100*VitFluxAir/72; //equivaut a mesure pression
            pression[1] = Pot2.read()*300*VitFluxAir/72; //equivaut a mesure pression
            pression[2] = Pot2.read()*600*VitFluxAir/72; //equivaut a mesure pression
            pression[3] = Pot2.read()*700*VitFluxAir/72; //equivaut a mesure pression
            pression[4] = Pot2.read()*700*VitFluxAir/72; //equivaut a mesure pression
            pression[5] = Pot2.read()*600*VitFluxAir/72; //equivaut a mesure pression
            pression[6] = Pot2.read()*300*VitFluxAir/72; //equivaut a mesure pression
            pression[7] = Pot2.read()*100*VitFluxAir/72; //equivaut a mesure pression
            Fx = Pot1.read() * 5;
            Fz = Pot1.read() * 5;
            Aim = Pot1.read() * 40 - 20;
            Wifi.printf("$z,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f,%0.0f\r\n",pression[0],pression[1],pression[2],pression[3],pression[4],pression[5],pression[6],pression[7],Fx,Fz,Aim);
            ecranchange=true;
        }
        if (ecranchange) {
            AffichageEcransp2();
            ecranchange=false;
        }
    }
}

