// acquerir la temperature avec le LM75B
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LM75B.h"
#include "acquisition.h"
#include "affichagesp1.h"
#include "wifiesp8266.h"

float VitFluxAir = 0;
float ConsigneFluxAir = 0;
float Freqhelice = 0;
float Temperature = 0;
float humidite = 0;

RawSerial PC(USBTX, USBRX);
WifiEsp8266 Wifi(PA_11,PA_12); // WifiEsp8266(PinName Txd, PinName Rxd,float _timeout);
DigitalOut En(PC_11);
Ticker test1;
bool Drticker1 = false;
void event1()
{
    Drticker1 = true;
}

int main()
{
    En.write(1);
    char WifiPhrase[maxdata];
    bool ecranchange=false;
    AnalogIn Pot1(A0);
    AnalogIn Pot2(A1);
    LM75B sensor(D14,D15);
    AffichageEcransp1();
    PC.baud(921600);
    PC.printf("Hello je suis SP1\r\n");
    test1.attach(&event1,1);
    while (true) {
        if (Wifi.dataready()) {
            strcpy(WifiPhrase,Wifi.read());
            switch (WifiPhrase[1]) {
                case 'F':
                    ConsigneFluxAir=ConsigneFluxAir+1;
                    Wifi.printf("$B%0.0f\r\n",ConsigneFluxAir);
                    ecranchange=true;
                    break;
                case 'G' :
                    ConsigneFluxAir=ConsigneFluxAir-1;
                    Wifi.printf("$B%0.0f\r\n",ConsigneFluxAir);
                    ecranchange=true;
                    break;
                default : ;
            }
        }
        if (Drticker1) {
            Drticker1 = false;
            Temperature = sensor.read();
            humidite =Pot2.read() *92;
            VitFluxAir = Pot1.read()*72;
            Wifi.printf("$Z,%0.0f,%0.0f,%0.0f\r\n",VitFluxAir,Temperature,humidite);
            ecranchange=true;
        }
        if (ecranchange) {
            AffichageEcransp1();
            ecranchange=false;
        }
    }
}


