
#include "mbed.h"
#include "sim800l.h"
char _DataTmp[maxdata + 1]; // tableau de donnees pour stocker pendant reception
char _Data[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
char _DataSms[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
char _Phrase[maxdata + 1]; // pour convertir en phrase avant envoi
Sim800l::Sim800l(PinName tx, PinName rx, PinName resetpin,int baudrate):serial(tx,rx), reset (resetpin)
{
    reset.write(0);  //reset
    _DataTmp = new char[maxdata + 1]; // tableau de donnees pour stocker pendant reception
    _Data = new char[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
    _DataSms = new char[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
    _Phrase = new char[maxdata + 1]; // pour convertir en phrase avant envoi
    _DataTmp[0] = 0;
    _Data[0] = 0;
    _DataPtr = 0;
    _DataReady = false;
    _SmsReady = false;
    _IndexSms = 0;
    serial.baud(baudrate);  // configure data baud
}
// retourne incdex du sms recu
int Sim800l::IndexSmsRecu(void)
{
    return _IndexSms;
}
// return true si une phrase a ete recue
bool Sim800l::dataready(void)
{
    return _DataReady;
}
// return phrase recu
char * Sim800l::read(void)
{
    _DataReady = false;
    return _Data;
}
// recoit les caractere serie et les stocke en tache de fond
void Sim800l::receive()
{
    char inChar;
    if (serial.readable()) {
        inChar = serial.getc();
//        pc.putc(inChar);  // pour echo
        switch (inChar) {
            case '\n' :
                if (_DataPtr > 1) {
//                    pc.printf("-%s/\r\n",_DataTmp);
                    if (strncmp(_DataTmp,"+CMTI:",6)==NULL) { // recoit sms +CMTI: "SM",3
                        if (sscanf(_DataTmp,"+CMTI: \"SM\",%d",&_IndexSms)==1) _SmsReady = true;
                    } else {  // cmde
                        strcpy(_Data,_DataTmp);
                        _DataReady = true;
                    }
                }
                _DataTmp[0] = 0;
                _DataPtr = 0;
                break;
            case 0 :
                break;
            case '\r' :
                break;
            case ' ' :
                if (_DataPtr==1) {
                    if ( _DataTmp[0]=='>') {
                        strcpy(_Data,_DataTmp);
                        _DataReady = true;
                        _DataTmp[0] = 0;
                        _DataPtr = 0;
                        break;
                    }
                }
            default :
                _DataTmp[_DataPtr] = inChar;
                _DataPtr = _DataPtr + 1;
                _DataTmp[_DataPtr] = 0;
        }
        if (_DataPtr >= maxdata) {  // si phrase trop longue vide phrase
            _DataTmp[0] = 0;
            _DataPtr = 0;
        }
    }
}
// fonction appele en fin timerout
void Sim800l::Ftimeout()
{
    FinTimeOut = true;
}
// defini time out et le lance
void Sim800l::SetTimeout(float delay)
{
    FinTimeOut = false;
    _timeout.attach(callback(this,&Sim800l::Ftimeout),delay);
//  timeout.attach(callback(this, &Sonar::trigger_toggle), 10.0e-6);
}
// attente reponse dans *reponse jusqua timeout
bool Sim800l::waitreponse(const char *reponse,float timeout)
{
    SetTimeout(timeout);
    while (FinTimeOut==false) { // attente Ok
        if (dataready()) {
            if (strcmp(read(),reponse)==0) return true;
        }
    }
    return false; // timeout ecoule donc erreur
}
// envoi commande et attend reponse
bool Sim800l::writecmdandwaitreponse(const char *data, const char *reponse,float timeout)
{
    serial.printf("%s",data);
    return waitreponse(reponse,timeout);
}
// initialise SIM800L en mode SMS Texte
// configure baud
// Renvoi
// - true tout s'est bien passé
// - false erreur
// cmdecho = true --> copie donne de reponse sim800l vers pc
bool Sim800l::init()
{
    bool resultat = true;
    _DataTmp[0] = 0;
    _Data[0] = 0;
    _DataPtr = 0;
    _DataReady = false;
    _SmsReady = false;
    _IndexSms = 0;
    reset.write(0);  //reset
    thread_sleep_for(200);
    reset.write(1);
    serial.attach(callback(this, &Sim800l::receive), RawSerial::RxIrq); // affecte interruption sur Rx
    thread_sleep_for(1000);
    int i=0;
    while (!writecmdandwaitreponse("AT\r\n","OK",timeoutdefaut)) { // on attend 10 x pas plus
        if (i++>10) return false;
    }
    if (!waitreponse("Call Ready",timewaitCallready)) return false;
    if (!waitreponse("SMS Ready",timewaitSmsready)) return false;
    return writecmdandwaitreponse("AT+CMGF=1\r\n","OK",timeoutdefaut);  // Passe sms mode texte
}
bool Sim800l::smsclearall(void)
{
    return writecmdandwaitreponse("AT+CMGDA=\"DEL ALL\"\r\n","OK",timewaitSmsallclear);  // efface sms

}
bool Sim800l::smsready(void)
{
    bool _SmsReadytemp = _SmsReady;
    _SmsReady = false;
    return _SmsReadytemp;
}
bool Sim800l::sendsms(const char *phonenumber,const char *data)
{
    if (!writecmdandwaitreponse("AT+CMGF=1\r\n","OK",timeoutdefaut)) return false;  // Passe sms mode texte
    sprintf(_Phrase,"AT+CMGS=\"%s\"\r\n",phonenumber);
    if (!writecmdandwaitreponse(_Phrase,">",timeoutsendsms)) return false;  // ouvre sms
    sprintf(_Phrase,"%s%c\r\n",data,26);
    return writecmdandwaitreponse(_Phrase,"OK",timeoutsendsms); // envoi message
}
// attente r eponse dans *reponse
bool Sim800l::waitsmsreponse(const char *reponse,float timeout)
{
    char DataSmsOk = 0;
    _DataSms[0] = 0;
    SetTimeout(timeout);
    while (FinTimeOut==false) { // attente Ok
        if (dataready()) {
//            pc.printf("-%s --> %d:%s/\r\n",_Data,DataSmsOk,_DataSms);
            if (strcmp(read(),reponse)==0) return true;
            if (strncmp(_Data,"+CMGR:",6)==NULL) DataSmsOk = 1;
            else if (DataSmsOk!=0) {
                if (DataSmsOk > 1)  strcat(_DataSms,",");
                strcat(_DataSms,_Data);
                DataSmsOk = 2;
            }
//            pc.printf("-%s --> %d:%s/\r\n",_Data,DataSmsOk,_DataSms);
        }
    }
    return false; // timeout ecoule donc erreur
}
char *Sim800l::readtextesms()
{
    return _DataSms;
}
bool Sim800l::readsms(int index)
{
    serial.printf("AT+CMGR=%d,0\r\n",index);
    return waitsmsreponse("OK",timeoutreadsms);
}