#ifndef _sim800l_
#define _sim800l_
#include "mbed.h"

#define maxdata 1000
#define timeoutdefaut 1
#define timeoutsendsms 60
#define timeoutreadsms 5
#define timewaitCallready 10
#define timewaitSmsready 60
#define timewaitSmsallclear 25
#define timewaitCCID 2

extern RawSerial pc;

class Sim800l
{
public:
    /*
    * Constructor
    *
    * @param tx mbed pin to use for tx line of Serial interface
    * @param rx mbed pin to use for rx line of Serial interface
    * @param reset reset pin of the wifi module ()
    */
    Sim800l(PinName tx, PinName rx, PinName resetpin, int baudrate=9600);
    bool init();
    bool smsready(void);
    bool sendsms(const char *phonenumber,const char *data);
    bool readsms(int index);
    bool smsclearall(void);
    int IndexSmsRecu(void);
    char *readtextesms();

protected:
    RawSerial serial;
    DigitalOut reset;
    char *_DataTmp; // tableau de donnees pour stocker pendant reception
    char *_Data; // tableau de donnees lorsque toutes les donnees sont recues
    char *_DataSms; // tableau de donnees lorsque toutes les donnees sont recues
    char *_Phrase; // pour convertir en phrase avant envoi    
/*    
    char _DataTmp[maxdata + 1]; // tableau de donnees pour stocker pendant reception
    char _Data[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
    char _DataSms[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
    char _Phrase[maxdata + 1]; // pour convertir en phrase avant envoi
*/
    volatile int _DataPtr = 0; // position de stockage de la prochaine donnee a recevoir   
    volatile bool _DataReady = false;
    volatile bool _SmsReady = false;
    volatile int _IndexSms;
    Timeout _timeout; // permet deviter blocage en attente
    volatile bool FinTimeOut;
    bool dataready(void);
    char * read(void);
    void receive();
    void Ftimeout();
    void SetTimeout(float delay);
// attente r eponse dans *reponse
    bool waitreponse(const char *reponse,float timeout);
// envoi commande et attend reponse
    bool writecmdandwaitreponse(const char *data, const char *reponse,float timeout);
// attente r eponse dans *reponse
    bool waitsmsreponse(const char *reponse,float timeout);
};
#endif