#include "sim800l-c.h"
RawSerial sim800l(PA_9,PA_10);
DigitalOut sim800lreset (PA_12);

char _DataTmp[maxdata + 1]; // tableau de donnees pour stocker pendant reception
char _Data[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
char _DataSms[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
char _Phrase[maxdata + 1]; // pour convertir en phrase avant envoi
volatile int _DataPtr = 0; // position de stockage de la prochaine donnee a recevoir
volatile bool _DataReady = false;
volatile bool _SmsReady = false;
volatile int _IndexSms;
Timeout _timeout; // permet deviter blocage en attente
volatile bool FinTimeOut;
// recoit les caractere en tache de fond
int sim800lIndexSmsRecu(void)
{
    return _IndexSms;
}
bool sim800ldataready(void)
{
    return _DataReady;
}
char * sim800lread(void)
{
    _DataReady = false;
    return _Data;
}
void sim800lreceive()
{
    char inChar;
    if (sim800l.readable()) {
        inChar = sim800l.getc();
        pc.putc(inChar);  // pour echo
        switch (inChar) {
            case '\n' :
                if (_DataPtr > 1) {
//                    pc.printf("-%s/\r\n",_DataTmp);
                    if (strncmp(_DataTmp,"+CMTI:",6)==NULL) { // recoit sms +CMTI: "SM",3
                        if (sscanf(_DataTmp,"+CMTI: \"SM\",%d",&_IndexSms)==1) _SmsReady = true;
                    } else {  // cmde
                        strcpy(_Data,_DataTmp);
                        _DataReady = true;
                    }
                }
                _DataTmp[0] = 0;
                _DataPtr = 0;
                break;
            case 0 :
                break;
            case '\r' :
                break;
            case ' ' :
                if (_DataPtr==1) {
                    if ( _DataTmp[0]=='>') {
                        strcpy(_Data,_DataTmp);
                        _DataReady = true;
                        _DataTmp[0] = 0;
                        _DataPtr = 0;
                        break;
                    }
                }
            default :
                _DataTmp[_DataPtr] = inChar;
                _DataPtr = _DataPtr + 1;
                _DataTmp[_DataPtr] = 0;
        }
        if (_DataPtr >= maxdata) {  // si phrase trop longue vide phrase
            _DataTmp[0] = 0;
            _DataPtr = 0;
        }
    }
}
void Ftimeout()
{
    FinTimeOut = true;
}
void SetTimeout(float delay)
{
    FinTimeOut = false;
    _timeout.attach(&Ftimeout,delay);
}
// attente r eponse dans *reponse
bool sim800lwaitreponse(const char *reponse,float timeout)
{
    SetTimeout(timeout);
    while (FinTimeOut==false) { // attente Ok
        if (sim800ldataready()) {
            if (strcmp(sim800lread(),reponse)==0) return true;
        }
    }
    return false; // timeout ecoule donc erreur
}
// envoi commande et attend reponse
bool sim800lwritecmdandwaitreponse(const char *data, const char *reponse,float timeout)
{
    sim800l.printf("%s",data);
    return sim800lwaitreponse(reponse,timeout);
}
// initialise SIM800L en mode SMS Texte
// configure baud
// Renvoi
// - true tout s'est bien passé
// - false erreur
// cmdecho = true --> copie donne de reponse sim800l vers pc
bool sim800linit(int baudrate)
{
    bool resultat = true;
    _DataTmp[0] = 0;
    _Data[0] = 0;
    _DataPtr = 0;
    _DataReady = false;
    _SmsReady = false;
    _IndexSms = 0;
    sim800l.baud(baudrate);  // configure data baud
    sim800l.attach(&sim800lreceive, RawSerial::RxIrq); // affecte interruption sur Rx
    sim800lreset.write(0);  //reset
    thread_sleep_for(200);
    sim800lreset.write(1);
    thread_sleep_for(3000);
    int i=0;
    while (!sim800lwritecmdandwaitreponse("AT\r\n","OK",timeoutdefaut)) { // on attend 10 x pas plus
        if (i++>10) return false;
    }
    if (!sim800lwaitreponse("Call Ready",timewaitCallready)) return false;
    if (!sim800lwaitreponse("SMS Ready",timewaitSmsready)) return false;
    return sim800lwritecmdandwaitreponse("AT+CMGF=1\r\n","OK",timeoutdefaut);  // Passe sms mode texte
}
bool sim800lsmsclearall(void)
{
    return sim800lwritecmdandwaitreponse("AT+CMGDA=\"DEL ALL\"\r\n","OK",timewaitSmsallclear);  // efface sms

}
bool sim800lsmsready(void)
{
    bool _SmsReadytemp = _SmsReady;
    _SmsReady = false;
    return _SmsReadytemp;
}
bool sim800lsendsms(const char *phonenumber,const char *data)
{
    if (!sim800lwritecmdandwaitreponse("AT+CMGF=1\r\n","OK",timeoutdefaut)) return false;  // Passe sms mode texte
    sprintf(_Phrase,"AT+CMGS=\"%s\"\r\n",phonenumber);
    if (!sim800lwritecmdandwaitreponse(_Phrase,">",timeoutsendsms)) return false;  // ouvre sms
    sprintf(_Phrase,"%s%c\r\n",data,26);
    return sim800lwritecmdandwaitreponse(_Phrase,"OK",timeoutsendsms); // envoi message
}
// attente r eponse dans *reponse
bool sim800lwaitsmsreponse(const char *reponse,float timeout)
{
    char DataSmsOk = 0;
    _DataSms[0] = 0;
    SetTimeout(timeout);
    while (FinTimeOut==false) { // attente Ok
        if (sim800ldataready()) {
//            pc.printf("-%s --> %d:%s/\r\n",_Data,DataSmsOk,_DataSms);
            if (strcmp(sim800lread(),reponse)==0) return true;
            if (strncmp(_Data,"+CMGR:",6)==NULL) DataSmsOk = 1;
            else if (DataSmsOk!=0) {
                if (DataSmsOk > 1)  strcat(_DataSms,",");
                strcat(_DataSms,_Data);
                DataSmsOk = 2;
            }
//            pc.printf("-%s --> %d:%s/\r\n",_Data,DataSmsOk,_DataSms);
        }
    }
    return false; // timeout ecoule donc erreur
}
char *sim800lreadtextesms()
{
    return _DataSms;
}
bool sim800lreadsms(int index)
{
    sim800l.printf("AT+CMGR=%d,0\r\n",index);
    return sim800lwaitsmsreponse("OK",timeoutreadsms);
}