
#include "mbed.h"
#include "sim5320e.h"
/*
char _DataTmp[maxdata + 1]; // tableau de donnees pour stocker pendant reception
char _Data[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
char _DataSms[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
c // pour convertir en phrase avant envoi
*/
sim5320e::sim5320e(PinName tx, PinName rx, PinName resetpin,int baudrate):serial(tx,rx), reset (resetpin)
{
    reset.write(0);  //reset
    /*    _DataTmp = new char[maxdata + 1]; // tableau de donnees pour stocker pendant reception
        _Data = new char[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
        _DataSms = new char[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
        */
    _DataTmp[0] = 0;
    _Data[0] = 0;
    _DataPtr = 0;
    _DataReady = false;
    _SmsReady = false;
    _IndexSms = 0;
    serial.baud(baudrate);  // configure data baud
}
// retourne incdex du sms recu
int sim5320e::IndexSmsRecu(void)
{
    return _IndexSms;
}
// return true si une phrase a ete recue
bool sim5320e::dataready(void)
{
    return _DataReady;
}
// return phrase recu
char * sim5320e::read(void)
{
    _DataReady = false;
    return _Data;
}
// recoit les caractere serie et les stocke en tache de fond
void sim5320e::receive()
{
    char inChar;
    if (serial.readable()) {
        inChar = serial.getc();
//        pc.putc(inChar);  // pour echo
        switch (inChar) {
            case '\n' :
                if (_DataPtr > 1) {
//                    pc.printf("-%s/\r\n",_DataTmp);
                    if (strncmp(_DataTmp,"+CMTI:",6)==NULL) { // recoit sms +CMTI: "SM",3
                        if (sscanf(_DataTmp,"+CMTI: \"SM\",%d",&_IndexSms)==1) _SmsReady = true;
                    } else {  // cmde
                        strcpy(_Data,_DataTmp);
                        _DataReady = true;
                    }
                }
                _DataTmp[0] = 0;
                _DataPtr = 0;
                break;
            case 0 :
                break;
            case '\r' :
                break;
            case ' ' :
                if (_DataPtr==1) {
                    if ( _DataTmp[0]=='>') {
                        strcpy(_Data,_DataTmp);
                        _DataReady = true;
                        _DataTmp[0] = 0;
                        _DataPtr = 0;
                        break;
                    }
                }
            default :
                _DataTmp[_DataPtr] = inChar;
                _DataPtr = _DataPtr + 1;
                _DataTmp[_DataPtr] = 0;
        }
        if (_DataPtr >= maxdata) {  // si phrase trop longue vide phrase
            _DataTmp[0] = 0;
            _DataPtr = 0;
        }
    }
}
// fonction appele en fin timerout
void sim5320e::Ftimeout()
{
    FinTimeOut = true;
}
// defini time out et le lance
void sim5320e::SetTimeout(float delay)
{
    FinTimeOut = false;
    _timeout.attach(callback(this,&sim5320e::Ftimeout),delay);
}
// attente reponse dans *reponse jusqua timeout
bool sim5320e::waitreponse(const char *reponse,float timeout)
{
    SetTimeout(timeout);
    while (FinTimeOut==false) { // attente Ok
        if (dataready()) {
            char tmp[maxdata + 1];
            strcpy(tmp,read());
            if (strcmp(tmp,reponse)==0) return true;
            if (strcmp(tmp,"ERROR")==0) return false;
        }
    }
    return false; // timeout ecoule donc erreur
}
// envoi commande et attend reponse
bool sim5320e::writecmdandwaitreponse(const char *data, const char *reponse,float timeout)
{
    serial.printf("%s\r\n",data);
    return waitreponse(reponse,timeout);
}
// initialise sim5320e en mode SMS Texte
// configure baud
// Renvoi
// - true tout s'est bien passé
// - false erreur
// cmdecho = true --> copie donne de reponse sim5320e vers pc
bool sim5320e::init()
{
    bool resultat = true;
    _DataTmp[0] = 0;
    _Data[0] = 0;
    _DataPtr = 0;
    _DataReady = false;
    _SmsReady = false;
    _IndexSms = 0;
    reset.write(0);  //reset
    thread_sleep_for(100);
    reset.write(1);
    thread_sleep_for(1000);
    serial.attach(callback(this, &sim5320e::receive), RawSerial::RxIrq); // affecte interruption sur Rx
    int i=0;
    while (!writecmdandwaitreponse("AT","START",timeoutdefaut)) { // on attend 10 x pas plus
        if (i++>10) return false;
    }
    if (!waitreponse("+CPIN: READY",timewaitCallready)) return false;
    if (!waitreponse("SMS DONE",timewaitCallready)) return false;
    return waitreponse("PB DONE",timewaitCallready);
}

// initialise mode sms
bool sim5320e::smsinit(void)
{
    if (!writecmdandwaitreponse("AT+CMGF=1","OK",timeoutdefaut)) return false;  // sms mode texte
    if (!writecmdandwaitreponse("AT+CNMI=2,1","OK",timeoutdefaut)) return false;  // tretourne tout te
    if (!writecmdandwaitreponse("AT+CSDH=1","OK",timeoutdefaut)) return false;
    return writecmdandwaitreponse(" AT+CPMS=\"SM\",\"SM\",\"SM\"","OK",timeoutdefaut);;
}
// efface tous les message
bool sim5320e::smsclearall(void)
{
    return writecmdandwaitreponse("AT+CMGD=1,4","OK",timewaitSmsallclear);  // efface sms

}
bool sim5320e::smsready(void)
{
    bool _SmsReadytemp = _SmsReady;
    _SmsReady = false;
    return _SmsReadytemp;
}
bool sim5320e::sendsms(const char *phonenumber,const char *data)
{
    if (!writecmdandwaitreponse("AT+CMGF=1","OK",timeoutdefaut)) return false;  // Passe sms mode texte
    char _Phrase[maxdata + 1];
    sprintf(_Phrase,"AT+CMGS=\"%s\"",phonenumber);
    if (!writecmdandwaitreponse(_Phrase,">",timeoutdefaut)) return false;  // ouvre sms
    sprintf(_Phrase,"%s%c",data,26);
    return writecmdandwaitreponse(_Phrase,"OK",timeoutsendsms); // envoi message
}
// Lecture sms jusqua reception reponse dans *reponse
bool sim5320e::waitsmsreponse(const char *reponse,float timeout)
{
    char DataSmsOk = 0;
    _DataSms[0] = 0;
    SetTimeout(timeout);
    while (FinTimeOut==false) { // attente Ok
        if (dataready()) {
//           pc.printf("-%s --> %d:%s/\r\n",_Data,DataSmsOk,_DataSms);
            if (strcmp(read(),reponse)==0) return true;  // sms termine cest tout bon
            if (strncmp(read(),"+CMS ERROR",9)==0) return false;  // sms termine cest tout bon
            if (strncmp(read(),"+CMGR:",6)==NULL) DataSmsOk = 1;
            else if (DataSmsOk!=0) {
                if (DataSmsOk > 1)  strcat(_DataSms,",");
                strcat(_DataSms,_Data);
                DataSmsOk = 2;
            }
//            pc.printf("-%s --> %d:%s/\r\n",_Data,DataSmsOk,_DataSms);
        }
    }
    return false; // timeout ecoule donc erreur
}
char *sim5320e::readtextesms()
{
    return _DataSms;
}
bool sim5320e::readsms(int index)
{
    serial.printf("AT+CMGR=%d\r\n",index);
    return waitsmsreponse("OK",timeoutreadsms);
}