#include "gps_sample.h"

Gps::Gps(PinName Txd, PinName Rxd) : Serial(Txd,Rxd)
{
    _num = 0;
    _msg[0] = 0;
    _time = 0; // date
    _latitude = 0;
    _ns = 0; // nombre satellite.
    _longitude = 0;
    _ew = 0;
    _lock = 0;
}
// Gps sample
char Gps::sample()
{
    char data, _gps_data_ok = false;
    if(readable()) {
        data = getc();
        switch (data) {
            case '$' :  // debut de phrase Gps
                _num = 1;
                _msg [0] = '$';
                _msg [1] = 0;
                break;
            case '\f' :
                break;
            case '\r' : // fin de phrase Gps
                if (_msg [0] == '$') { // on a recu un message. // faudrait tester la parite a voir
                    if(sscanf(_msg, "$GPGGA,%f,%f,%c,%f,%c,%d,%d", &_time, &_latitude, &_ns, &_longitude, &_ew, &_lock,&_nbsattelite) >= 1) {
                        if(_ns == 'S') {
                            _latitude  *= -1.0;
                        }
                        if(_ew == 'W') {
                            _longitude *= -1.0;
                        }
                        float degrees = _trunc(_latitude / 100.0f);
                        float minutes = _latitude - (degrees * 100.0f);
                        _latitude = degrees + minutes / 60.0f;
                        degrees = _trunc(_longitude / 100.0f * 0.01f);
                        minutes = _longitude - (degrees * 100.0f);
                        _longitude = degrees + minutes / 60.0f;
                        _gps_data_ok = true;
                        _num = 0;
                        _msg[0] = 0;
                    }
                }
                break;
            default:
                if ((_num < trame_nmea_max)&&(_msg [0] == '$')) {
                    _msg [_num++] = data;
                    _msg [_num] = 0;
                }
        }
    }
    return _gps_data_ok;
}

float Gps::_trunc(float v)
{
    if(v < 0.0) {
        v*= -1.0;
        v = floor(v);
        v*=-1.0;
    } else {
        v = floor(v);
    }
    return v;
}

float Gps::time()
{
    return _time;
}

float Gps::latitude()
{
    return _latitude;
}
char Gps::ns()
{
    return _ns;
}

float Gps::longitude()
{
    return _longitude;
}
char Gps::ew()
{
    return _ew;
}
int Gps::lock()
{
    return _lock;
}
int Gps::nbsattelite()
{
    return _nbsattelite;
}

