#ifndef _Sf_gps_rs232_
#define _Sf_gps_rs232_
#include "mbed.h"
#define trame_nmea_max 84

const double pi = 3.14159265;
const double rayon = 6378137.0;

class Gps : public Serial
{
public:
    Gps(PinName Txd, PinName Rxd);
    void receive();  //recoit les data gps et les stocks puis produit les donnees en cas de reception
    double time(); // date
    double latitude();
    char ns(); // nombre satellite.
    double longitude();
    char ew();
    int lock();
    int nbsattelite();
    char sample();
    float vitesse();
    char vitesse_ok();
    float vitesse_gps();
    char vitesse_gps_ok();
private:
    unsigned int _num; // nombre caractere recu dans la phrase gps en court
    char _msg[trame_nmea_max+1];   //
    float _time; // date
    float _old_time;
    float _latitude;
    float _old_latitude;
    char _ns;
    float _longitude;
    float _old_longitude;
    char _ew;
    int _lock;
    int _old_lock;
    int _nbsattelite;
    char _gps_data_ok;
    double _trunc(double v);
    double _time_sec(double time);
    float _vitesse_gps;
    char _vitesse_gps_ok;
};
#endif