#include "mbed.h"
#include "wifiesp8266.h"
WifiEsp8266::WifiEsp8266(PinName Txd, PinName Rxd) : RawSerial(Txd,Rxd)
{
    baud(Baud);
    _DataPtr = 0;
    _DataReady = false;
    attach(this,&WifiEsp8266::receive, RawSerial::RxIrq);
}

char * WifiEsp8266::read(void)
{
    _DataReady = false;
    return _Data;
}

bool WifiEsp8266::dataready(void)
{
    return _DataReady;
}

// reception phrase de type '$' "....' "\r\n"
void WifiEsp8266::receive(void)
{
    bool _PhraseComplete = false;
    char inChar;
    while (readable() && (_PhraseComplete == false)) {
        inChar = getc();
        switch (inChar) {
            case '$' :
                _DataPtr = 0;
                _DataTmp[_DataPtr++] = inChar;
                _DataTmp[_DataPtr] = 0;
                break;
            case '\n' :
                if (_DataPtr > 1) {
                    strcpy(_Data,_DataTmp);
                    _PhraseComplete = true;
                }
                _DataTmp[0] = 0;
                _DataPtr = 0;
                break;
            case '\r' :
                break;
            default :
                if (_DataPtr > 0) {
                    _DataTmp[_DataPtr++] = inChar;
                    _DataTmp[_DataPtr] = 0;
                }
        }
        if (_DataPtr >= maxdata) {  // si phrase trop longue vide phrase
            _DataTmp[0] = 0;
            _DataPtr = 0;
            _PhraseComplete = false;
        }
    }
    _DataReady = _PhraseComplete;
}