#include "Sf18B20.h"
Sf18B20::Sf18B20(PinName pin) : DS1820(pin)
{
    dataready = false;
}
void Sf18B20::flip(void)
{
    data18B20 = read();
    dataready = true;
    startConversion();
}
bool Sf18B20::Run(unsigned period)
{
    if (begin())
    {
    startConversion();
    dataready = false;
    flipper.attach(this,&Sf18B20::flip,period);
    return true;
    }
    return false;
}
void Sf18B20::Stop(void)
{
    flipper.detach();
    dataready = false;
}

double Sf18B20::Read18B20(void)
{
    return data18B20;
}
bool Sf18B20::DataReady(void)
{
    if (dataready) {
        dataready = false;
        return true;
    }
    return false;
}
