#ifndef _MySerial_
#define _MySerial_
// driver interface serie
// cette class permet de recevoir et transmettre des donnees serie suivant un protocole
// $x,.,.,.,.terminaison  // terminaison peut etre "\r","\n" ou "\r\n"
// les donnees sont acquises en tache de fond.
//
// Les méthodes :
// - MySerial(PinName Txd, PinName Rxd,float _TimeOut=NULL);  // param txd et rxd. Timeout pas obligatoire
// - bool dataready(void); : retourne true lorsquune phrase est acquise
// - char * read(void); : retourne phrase lue sans la terminaison
//
// exemple
// dans main.cpp
/*
#include "mbed.h"
#include "MySerial.h"
//
//

MySerial PC(USBTX,USBRX); // liaison PC
char PCPhrase[maxdata];    // pour stocker phrase PC

void main (void)
{
    // recevoir des donnees
    if (PC.dataready()) {
        strcpy(PCPhrase,PC.read()); // PCPhrase contient la phrase recu
        switch (PCPhrase[1]) {
            case 'B': // consigne de flux air
                ConsVitFluxAir = atof(PCPhrase+2); //
                datachange=true;   // on indique qune donne a change
                break;
            case 'L' :  // param pid
                if (sscanf(PCPhrase,"$L,%f,%f,%f",&coefp,&coefi,&coefd)>=1) datachange=true;
                break;
            default :
                ;
        }
    }

 if ((EnvoiePC!=0)&&(PCOk==true)) {
     while (!PC.writeable());
      PC.printf("$V,%0.1f,%0.1f\r\n",VitFluxAir,Frequencehelice);
     }
}
*/
// taille maximum d'une phrase recue
#ifndef maxdata
#define maxdata 99
#endif
#define Baud 921600
class MySerial : public RawSerial
{
public:
    MySerial(PinName Txd, PinName Rxd,float _TimeOut=NULL);      // _TimeOute pour chien de garde en s
    bool dataready(void);
    char * read(void);
private:
// reception phrase Serial
    char _DataTmp[maxdata + 1]; // tableau de donnees pour stocker pendant reception
    char _Data[maxdata + 1]; // tableau de donnees lorsque toutes les donnees sont recues
//    char *_DataTmp; // tableau de donnees pour stocker pendant reception
//    char *_Data; // tableau de donnees lorsque toutes les donnees sont recues
    int _DataPtr; // position de stockage de la prochaine donnee a recevoir
    bool _Canal1Ok;
    bool _Canal2Ok;
    Ticker TGarde;
    bool _DataReady;
    float _TimeOut;
    void receive();  //recoit les data gps et les stocks puis produit les donnees en cas de reception
    void Tevent(void);
};
#endif
