#include "mbed.h"
#include "MySerial.h"
// 
MySerial::MySerial(PinName Txd, PinName Rxd, float TimeOut) : RawSerial(Txd,Rxd)
{
    baud(Baud);
    _TimeOut = TimeOut;
//    _DataTmp = new char[maxdata + 1];
//    _Data = new char[maxdata + 1];
    _DataPtr = 0;
    _DataReady = false;
    _Canal1Ok = false;
    _Canal2Ok = false;
    attach(callback(this,&MySerial::receive), RawSerial::RxIrq);
    if (_TimeOut != NULL) TGarde.attach(callback(this,&MySerial::Tevent),_TimeOut);  // pour chien de garde
}
void MySerial::Tevent(void)  // chien de garde
{
    if (!_Canal1Ok) printf("$Y\r\n");
    if (!_Canal2Ok) printf("$y\r\n");
    _Canal1Ok = false;
    _Canal2Ok = false;
}
char * MySerial::read(void)
{
    _DataReady = false;
    return _Data;
}

bool MySerial::dataready(void)
{
    return _DataReady;
}

// reception phrase de type '$' "....' "\r\n"
void MySerial::receive(void)
{
    bool _PhraseComplete = false;
    char inChar;
    while (readable() && (_PhraseComplete == false)) {
        inChar = getc();
        switch (inChar) {
            case '$' :
                _DataPtr = 0;
                _DataTmp[_DataPtr++] = inChar;
                _DataTmp[_DataPtr] = 0;
                break;
            case '\r' :
                ;
            case '\n' :
                if (_DataPtr > 1) {
                    strcpy(_Data,_DataTmp);
                    _PhraseComplete = true;
                    if (_TimeOut!=NULL) {
                        if ((_Data[1] >> 5)==2)     _Canal1Ok = true;
                        if ((_Data[1] >> 5)==3)     _Canal2Ok = true;
                    }
                }
                _DataTmp[0] = 0;
                _DataPtr = 0;
                break;
            default :
                if (_DataPtr > 0) {
                    _DataTmp[_DataPtr++] = inChar;
                    _DataTmp[_DataPtr] = 0;
                }
        }
        if (_DataPtr >= maxdata) {  // si phrase trop longue vide phrase
            _DataTmp[0] = 0;
            _DataPtr = 0;
            _PhraseComplete = false;
        }
    }
    _DataReady = _PhraseComplete;
}
